% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-fit.R
\name{JAGS_check_and_list}
\alias{JAGS_check_and_list}
\alias{JAGS_check_and_list_fit_settings}
\alias{JAGS_check_and_list_autofit_settings}
\title{Check and list 'JAGS' fitting settings}
\usage{
JAGS_check_and_list_fit_settings(
  chains,
  adapt,
  burnin,
  sample,
  thin,
  autofit,
  parallel,
  cores,
  silent,
  seed,
  check_mins = list(chains = 1, adapt = 50, burnin = 50, sample = 100, thin = 1),
  call = ""
)

JAGS_check_and_list_autofit_settings(
  autofit_control,
  skip_sample_extend = FALSE,
  call = ""
)
}
\arguments{
\item{chains}{number of chains to be run, defaults to \code{4}}

\item{adapt}{number of samples used for adapting the MCMC chains, defaults to \code{500}}

\item{burnin}{number of burnin iterations of the MCMC chains, defaults to \code{1000}}

\item{sample}{number of sampling iterations of the MCMC chains, defaults to \code{4000}}

\item{thin}{thinning interval for the MCMC samples, defaults to \code{1}}

\item{autofit}{whether the models should be refitted until convergence criteria
specified in \code{autofit_control}. Defaults to \code{FALSE}.}

\item{parallel}{whether the chains should be run in parallel \code{FALSE}}

\item{cores}{number of cores used for multithreading if \code{parallel = TRUE},
defaults to \code{chains}}

\item{silent}{whether the function should proceed silently, defaults to \code{TRUE}}

\item{seed}{seed for random number generation}

\item{check_mins}{named list of minimal values for which
should some input be checked. Defaults to:
\describe{
\item{chains}{\code{1}}
\item{adapt}{\code{50}}
\item{burnin}{\code{50}}
\item{sample}{\code{100}}
\item{thin}{\code{1}}
}}

\item{call}{string to be placed as a prefix to the error call.}

\item{autofit_control}{a list of arguments controlling the autofit function.
Possible options are:
\describe{
\item{max_Rhat}{maximum R-hat error for the autofit function.
Defaults to \code{1.05}.}
\item{min_ESS}{minimum effective sample size. Defaults to \code{500}.}
\item{max_error}{maximum MCMC error. Defaults to \code{1.01}.}
\item{max_SD_error}{maximum MCMC error as the proportion of standard
deviation of the parameters. Defaults to \code{0.05}.}
\item{max_time}{list specifying the time \code{time} and \code{units}
after which the automatic fitting function is stopped. The units arguments
need to correspond to \code{units} passed to \link[base]{difftime} function.}
\item{sample_extend}{number of samples between each convergence check. Defaults to
\code{1000}.}
}}

\item{skip_sample_extend}{whether \code{sample_extend}
is allowed to be NULL and skipped in the check}
}
\value{
\code{JAGS_check_and_list_fit_settings} invisibly returns a
list of checked fit settings. \code{JAGS_check_and_list_autofit_settings}
invisibly returns a list of checked autofit settings.
parameter names.
}
\description{
Checks and lists settings for the
\link{JAGS_fit} function.
}
