#' @title  Draw an FROC curve and  an AFROC curve using Bayesian approach.
#'  Build S4 classes by stan in the case of
#' Single reader and Single modality (srsc)
#'
#'
#'@description  Build the S4 class by stan with your single reader
#'and single modality data \code{dataList}.
#'

#'
#'@description The model is the author's Bayesian model introduced the author's paper.
#'@description  Before running the function \code{stan_srsc}, you should confirm
#'that your dataset is correctly formulated by the function \code{viewdataSRSC()}.

#'@inheritParams fit_Bayesian_FROC

#'@param dataList it should include  \code{f, h, NL, NI, C}.
#'The detail of these dataset, please see the endowed datasets.
#'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
#' however,
#'its each confidence level should not included  your data. So, to confirm
#'your false positives and hits are correctly correspondence
#'to confidence levels,
#'you should confirm the orders by the function

#'@param PreciseLogLikelihood  If \code{PreciseLogLikelihood} = TRUE, then Stan calculates the precise log likelihood.
#'
#'If \code{PreciseLogLikelihood} = FALSE, then Stan calculates the log likelihood by dropping the constant terms in the likelihood function.


#'@param ModifiedPoisson This is dichotomous, that is TRUE or FALSE. If
#'ModifiedPoisson = TRUE, then Poisson rate of false alarm are per lesion,
#'and if ModifiedPoisson = FALSE, then Poisson rate of false alarm are per image.
#'To know detail, user read the author's paper in which I explained per image and per lesion.

#'@param DrawCurve This is a dichotomous, i.e., TRUE or FALSE. If you want to draw the FROC and AFROC curves, then you set \code{DrawCurve =TRUE}, if not then \code{DrawCurve =FALSE}. The reason why the author make this variable \code{DrawCurve} is that it take long time to draw curves, and thus default value is \code{FALSE}.


#'@param cha An argument of \code{rstan::stan}, which means the number of chains generated by Hamiltonian Monte Carlo method,
#'and, default = 4.
#'
#'
#'@param ite An argument of \code{rstan::stan}, which means the number of samples generated by Hamiltonian Monte Carlo method,
#'and, default = 3000. If your model could not converge, then raise this number.


#'@param dig An argument of \code{rstan::stan}, which means the Significant digits, used in stan Cancellation. default = 3,
#'
#'
#'@param war An argument of \code{rstan::stan}, which means the Burn in period, default = 1000,
#'
#'
#'@param see An argument of \code{rstan::stan}, which means a seed used in stan,
#'
#'
#' default = 1234.
#'  If your model could not converge,
#' then change this number.
#'
#'
#'@return An S4 class, created by  \code{rstan::stan}. Using this S4 class , you can go ahead to the next step,
#'that is, drawing the FROC curve and alternative FROC (AFROC) curves.
#'
#'
#'@examples
#' \donttest{

#'#First, we prepare the data endowed with this package.
#'
#'         dat  <- get(data("dataList.Chakra.1"))
#'
#'
#'
#'
#'#Second, we run the stan funtion
#'#with data named "dat"  and the author's Bayesian model.
#'
#'
#'            fit <-  fit_srsc(dat)
#'
#'
#'
#'
#'
#'
#' #Now, we get the stan's out put S4 class named "fit".
#'
#' #Using the return value "fit",
#'
#' #we can use the functions in the "rstan" package,
#' # To do so, we have to change the class from the inherited class to
#' # the class of the stanfit, as follows;
#'
#'
#'         fit <- as(fit, "stanfit")
#'
#' #   e.g.,
#'
#'           rstan::stan_trace(fit)
#'           rstan::stan_hist(fit)
#'           rstan::stan_rhat(fit)
#'
#'}#donttest

# devtools::document();help("curve_srsc") # Confirm reflection
# devtools::use_data(dataList.high.ability)
#' @export fit_srsc
#'@inheritParams DrawCurves_MRMC_pairwise

fit_srsc <- function(
  dataList,
  new.imaging.device=TRUE,

  DrawCurve = T,
  ModifiedPoisson = FALSE,
  PreciseLogLikelihood = FALSE,
  Drawcol = TRUE,
  summary =TRUE,
  DrawFROCcurve=TRUE,
  DrawAFROCcurve=FALSE,
  DrawCFPCTP=TRUE,
  mesh.for.drawing.curve=10000,
  make.csv.file.to.draw.curve=FALSE,
  cha = 4,
  ite = 3000,
  dig = 5,
  war = floor(ite/5),
  see = 1234){

  if (  ModifiedPoisson == FALSE  ) {
    fit_srsc_per_image_test(
      dataList = dataList,
      DrawCurve = DrawCurve,
      PreciseLogLikelihood = PreciseLogLikelihood,
      mesh.for.drawing.curve=mesh.for.drawing.curve,
      make.csv.file.to.draw.curve=make.csv.file.to.draw.curve,
      Drawcol = Drawcol,
      summary =summary,

      DrawFROCcurve=DrawFROCcurve,
      DrawAFROCcurve=DrawAFROCcurve,
      DrawCFPCTP=DrawCFPCTP,
      cha =  cha,
      ite  = ite,
      dig  = dig,
      war  = war,
      see  = see)




  } else
    if (  ModifiedPoisson == TRUE  ) {


      fit_srsc_per_lesion(
        dataList  = dataList,
        DrawCurve  =  DrawCurve,
        PreciseLogLikelihood  = PreciseLogLikelihood,
        mesh.for.drawing.curve=mesh.for.drawing.curve,
        make.csv.file.to.draw.curve=make.csv.file.to.draw.curve,
        DrawFROCcurve=DrawFROCcurve,
        DrawAFROCcurve=DrawAFROCcurve,
        DrawCFPCTP=DrawCFPCTP,
        Drawcol   = Drawcol,
        summary =summary,

        cha  =  cha,
        ite  =  ite,
        dig   =dig ,
        war   = war,
        see  = see )


    } else

      message("Format error occurs in your data")



}
