% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4class.R
\docType{class}
\name{stanfitExtended}
\alias{stanfitExtended}
\title{stanfitExtended  (S4 class)}
\description{
New Slots are added to  stanfit  which is an S4 class in  rstan :
}
\section{Fields}{

\describe{
\item{\code{dataList}}{Object of class  "list" , containing data that needs to go in further analysis.}

\item{\code{metadata}}{Object of class  "list" , containing meta data from slot1, e.g., the cumulative hits and cumulative false alarms.}

\item{\code{studyDesign}}{Object of class  "character" , indicating MRMC (multiple reader and multiple modality) or srsc (single reader and single case)}
}}

\section{Slots}{

\describe{
\item{\code{plotdataMRMC}}{Plot data for MRMC case.}

\item{\code{plotdata}}{This is a data frame with four components which is used to draw curves such as FROC curves and AFROC curves.}

\item{\code{dataList}}{This is a dataset. Using the dataset, the fitting has done.}

\item{\code{studyDesign}}{This is character, e.g., "srsc.per.image",  "srsc.per.lesion",}

\item{\code{metadata}}{This is additional data calculated from dataList, such as cumulative hits and false alarms,...,etc.}

\item{\code{WAIC}}{This is a WAIC.}

\item{\code{convergence}}{This is TRUE or FALSE. If TRUE, then it means your model is good in the R hat criterion.}

\item{\code{PreciseLogLikelihood}}{This is TRUE or FALSE. If TRUE, then target formulation is used in the stan file.}

\item{\code{chisquare}}{This is a chi square calculated with Expected A Posterior estimates, i.e., the posterior mean estimator.}

\item{\code{index}}{THis is for programming phase.}

\item{\code{Divergences}}{This is a number of the divergence transitions in the MCMC simulation.}

\item{\code{MCMC.Iterations}}{A MCMC iterations which does not count the burn-in period.}

\item{\code{Divergence.rate}}{A divergence rate, that is the number of the divergence iterations over total MCMC iterations. Burn-in period is not included.}

\item{\code{model_name}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{model_pars}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{par_dims}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{mode}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{sim}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{inits}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{stan_args}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{stanmodel}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{date}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}

\item{\code{.MISC}}{This is a slot from the stanfit which is an S4 class defined in the rstan package.}
}}

