#' @title  fit a model to data in the case of
#' Single reader and Single modality (srsc).
#'
#'@description  Build a fitted model object to data in case of  single reader
#'and single modality data \code{dataList}. FPF is per image.
#'@details Revised 2019.Jun. 17
#'@inheritParams fit_srsc

#'@inheritParams fit_Bayesian_FROC
#'@inheritParams DrawCurves_MRMC_pairwise
#'@param dataList it should include  \code{f, h, NL, NI, C}.
#'The detail of these dataset, please see the endowed datasets.
#'Note that the maximal number of confidence level, denoted by  \code{C}, are included,
#' however,
#' should not include its each confidence level in \code{dataList}
#'
#'
#'
#'
#'@return An S4 object of class \code{stanfitExtended}.
#'
#'@examples
#' \donttest{
#'#First, prepare the example data from this package.
#'
#'
#'
#'         dat  <- get(data("dataList.Chakra.1"))
#'
#'
#'
#'
#'#Second, fit a model to data named "dat"
#'
#'
#'
#'
#'
#'            fit <-  fit_srsc_per_image_test(dat)
#'
#'
#'
#'
#'
#'
#'
#' #      Close the graphic device to avoid errors in R CMD check.
#'
#'          Close_all_graphic_devices()
#'
#'
#'}# dottest
#'@import Rcpp
#' @export fit_srsc_per_image_test
#  @importFrom stats  rchisq
# @importFrom base system.file #this code must not run, it cause error.
#'
# @importFrom "graphics", "par"
# @importFrom "stats", "pnorm", "qnorm", "rexp", "rnorm", "rpois", "runif", "var")
# devtools::document();help("curve_srsc_per_image_test") # Confirm reflection



fit_srsc_per_image_test <- function(
  dataList,
  new.imaging.device=TRUE,
  dataList.Name = "",

  DrawCurve = TRUE,
  PreciseLogLikelihood = TRUE,
  Drawcol = TRUE,
  make.csv.file.to.draw.curve=FALSE,
  mesh.for.drawing.curve=10000,
  summary =TRUE,
  DrawFROCcurve=TRUE,
  DrawAFROCcurve=FALSE,
  DrawCFPCTP=TRUE,
  cha = 4,
  ite = 3000,
  dig = 5,
  war = floor(ite/5),
  see = 1234){

  message(" per image.\n")

  if(summary==TRUE) {  viewdata(dataList )}

  data <- metadata_srsc_per_image(dataList)

  ff <- data$ff
  hh <- data$hh
  C <- as.integer(data$C)
  f <- data$f
  h <- data$h
  NI <- data$NI
  NL <- data$NL



  if(PreciseLogLikelihood == FALSE  ){
    # scr <- "Model_srsc_per_image.stan";
    scr <- system.file("extdata", "Model_srsc_per_image.stan", package="BayesianFROC")
    #base::system.file is not go well
  }else{
    if(PreciseLogLikelihood == TRUE  ){
      # scr <- "Model_srsc_per_image_target.stan";
      scr <- system.file("extdata", "Model_srsc_per_image_target.stan", package="BayesianFROC")
    } else{
      print("PreciseLogLikelihood is allowed only two choice; TRUE or FALSE.")
    }}




  initial <-c("m"=1,"v"=5,"w"=0,"dz"=1/2)

  rstan_options(auto_write = TRUE)
  # scr <-rstan::stan_model(scr)
  #  fit  <-  rstan::sampling(
  #   file=scr,
  #
  #   model_name=scr, data=data,  verbose=F,
  #   seed=see, chains=cha, warmup=war, iter=ite
  #   , control = list(adapt_delta = 0.9999999,
  #                    max_treedepth = 15),init = initial
  # )

  scr <- rstan::stan_model(scr)# add


  if (summary==FALSE) {


    invisible(utils::capture.output(
      fit  <-  rstan::sampling(
        object= scr, data=data,  verbose=F,
        seed=see, chains=cha, warmup=war, iter=ite
        , control = list(adapt_delta = 0.9999999,
                         max_treedepth = 15),init = initial
      )
    ))
  }#if


  if (summary==TRUE) {

    fit  <-  rstan::sampling(
      object= scr, data=data,  verbose=FALSE,
      seed=see, chains=cha, warmup=war, iter=ite
      , control = list(adapt_delta = 0.9999999,
                       max_treedepth = 15),init = initial
    )

  }#if






  # fit  <-  rstan::stan(
  #   file=scr,
  #
  #   model_name=scr, data=data,  verbose=F,
  #   seed=see, chains=cha, warmup=war, iter=ite
  #   , control = list(adapt_delta = 0.9999999,
  #                    max_treedepth = 15),init = initial
  # )




  rstan::check_hmc_diagnostics(fit)
  check_rhat(fit)


  convergence <- ConfirmConvergence(fit,summary = summary)
  if(convergence ==FALSE){message("\n* So, model has no mean, we have to finish a calculation !!\n")

    fit.new.class <- methods::as(fit,"stanfitExtended")
    fit.new.class@metadata <-data
    fit.new.class@dataList <-dataList
    fit.new.class@studyDesign <-  "srsc.per.image"
    # if(PreciseLogLikelihood==TRUE) {fit.new.class@WAIC <- waic(fit,dig,summary=FALSE)}
    fit.new.class@convergence    <-  convergence
    # fit.new.class@chisquare <- chisquare
    fit.new.class@PreciseLogLikelihood    <-  PreciseLogLikelihood
    # fit.new.class@plotdata <-drawdata
    return(fit.new.class)
  }
  if(convergence ==TRUE){   if(summary==TRUE) message(crayon::silver("\n* We do not stop, since model converged.\n"))}

  if(summary==TRUE) {print(fit )}
  if(summary==FALSE) {  message(crayon::silver("\n* summary = TRUE for more details.\n"))}



  if(PreciseLogLikelihood == FALSE  ){
    if(summary==TRUE) message(crayon::silver("\n* WAIC was not caluculated, since log likelihood is not a precise value."))
  }else{
    if(PreciseLogLikelihood == TRUE  ){
      if(summary==TRUE)  message(crayon::silver("\n* WAIC was caluculated,\n since log likelihoodis is a precise value, i.e., the traget += statement are used in the stan file."))
      waic <-waic(fit,dig,summary=summary)
    } else{
      print("* PreciseLogLikelihood is allowed only two choice; TRUE or FALSE.")
    }}

  MCMC=(ite-war)*cha
  #--------- chi ^2 -----------Start
  p<-rstan::extract(fit)$p
  lchi<-rstan::extract(fit)$l
  EAP_p <-  array(0, dim=c(   C))
  EAP_l <-  array(0, dim=c(   C+1))

  s <-  array(0, dim=c(   C))
  t <-  array(0, dim=c(   C+1))
  for(mc in 1:MCMC){
    for(cd in 1:C){
      s[ cd]<-  EAP_p[ cd]

      EAP_p[ cd] <-  s[ cd]+ p[mc,cd]
    }
    for(cd in 0:C){
      t[ cd]<-  EAP_l[ cd]
      EAP_l[ cd] <-  t[ cd]+ lchi[mc,cd]
    }
  }
  EAP_p<-EAP_p/MCMC
  EAP_l<-EAP_l/MCMC

  ss<-vector()
  tt<-vector()
  for(cd in 1:C){

    ss[cd]<-(h[C+1-cd]-NL*EAP_p[cd])^2/(NL*EAP_p[cd])
    tt[cd]<-(f[C+1-cd]-NI*(EAP_l[cd]-EAP_l[cd+1]))^2/(NI*(EAP_l[cd]-EAP_l[cd+1]))

  }
  chisquare <- sum(ss)+sum(tt)
  chisquare <- signif(chisquare,digits = dig)
  #Draw the  AFROC curve~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  set.seed(1);ll<- stats::rchisq(mesh.for.drawing.curve, 1)
  lll<- 0.99+ll
  l<-append(ll,lll)

  x<- 1-exp(-l) #AFROC
  y <-  array(0, dim=c(length(x)))



  a<-rstan::extract(fit)$a
  b<-rstan::extract(fit)$b
  EAP_a <-  array(0, dim=c(  MCMC))
  EAP_b <-  array(0, dim=c(  MCMC))
  EAP_a <- 0
  EAP_b <- 0
  s<-0
  t<-0
  for(mc in 1:MCMC){
    s<-  EAP_a
    EAP_a <-  s+ a[mc]
    t<-  EAP_b
    EAP_b <-  t+ b[mc]
  }
  EAP_a<-EAP_a/MCMC
  EAP_b<-EAP_b/MCMC

  # EAP_a<- fit@inits[[4]]$a
  # EAP_b<- fit@inits[[4]]$b


  for(i in 1:length(x)){
    y[i]<-1-stats::pnorm(EAP_b*stats::qnorm(exp(-l[i]))-EAP_a)
  }

   if(DrawCurve == TRUE ||DrawCurve == T ){
    # if(PreciseLogLikelihood==TRUE){  title <- paste("Lesions = ",NL,", chi^2 =",chisquare, ", WAIC =",waic)}
    # if(PreciseLogLikelihood==FALSE){  title <- paste("Lesions = ",NL,",  chi^2 =",chisquare)}
     if(PreciseLogLikelihood==TRUE){  title <-  substitute(paste("Posterior mean of goodness of fit",integral( chi^2*(D/theta)*pi(theta/D)*d*theta, Theta, .  )  , "=",  chisquare , ", smaller is better.  WAIC =",waic),list(chisquare=chisquare, waic=waic)  )} # 2019 Jun 22 demo(plotmath)
     # if(PreciseLogLikelihood==TRUE){  title <- paste("chi^2 goodness of fit with posterior mean  = ", chisquare, ", smaller is better.  WAIC =",waic)}
     if(PreciseLogLikelihood==FALSE){  title <-  substitute(paste("Posterior mean of goodness of fit",integral( chi^2*(D/theta)*pi(theta/D)*d*theta, Theta, .  )  , "=",  chisquare , ", smaller is better." ),list(chisquare=chisquare)  )} # 2019 Jun 22 demo(plotmath)


    # if(  DrawFROCcurve == TRUE|| DrawCFPCTP==TRUE||DrawAFROCcurve==TRUE ){
    if (new.imaging.device==TRUE) {
      grDevices::dev.new()
      #  #grDevices::windows() # this cause the error in R CMD check
    }
    # }
    if( !( DrawFROCcurve == TRUE|| DrawCFPCTP==TRUE||DrawAFROCcurve==TRUE) ){
      if(summary==TRUE) message("\n* We do not draw anything according to your input.\n")
    }







    upper_x <- max(ff)
    upper_y <- 1.0
    graphics::par(lwd = 2 )
    suppressWarnings(graphics::par(new=TRUE));

    if(Drawcol==FALSE){
      if(DrawAFROCcurve==TRUE){
        suppressWarnings(graphics::par(new=TRUE)); plot(x,y,#AFROC
                                                        xlim = c(0,upper_x),ylim = c(0,upper_y),
                                                        col = 'black',
                                                        cex=0.1,
                                                        xlab = paste('mean of cumulative false positives per image (', NI," images)"  ),
                                                        ylab = paste('mean of cumulative hit per lesion (', NL," lesions)"  )
        )
      }
      if(DrawFROCcurve==TRUE){
        suppressWarnings(graphics::par(new=TRUE));
        plot(l,y,
             xlim = c(0,upper_x),ylim = c(0,upper_y),
             cex=1,
             col = 'black',
             xlab = '', ylab = '')
      }
      if(DrawCFPCTP==TRUE){
        suppressWarnings(graphics::par(new=TRUE));plot(ff,hh,cex=3,
                                                       xlim = c(0,upper_x),ylim = c(0,upper_y),col = 'black', xlab = '', ylab = '')

      }
    }


    if(Drawcol==TRUE){

      graphics::par(bg= "gray12", #"gray27",#"gray40",#"black",# ,
                    fg="gray",
                    col.lab="bisque2" ,#"bisque" ,#  "antiquewhite1",
                    col.axis="bisque2" ,##"bisque" "antiquewhite1",
                    col.main="bisque2" ,
                    cex.lab=1.5,
                    cex.axis=1.3
      )
      if(DrawAFROCcurve==TRUE){

        suppressWarnings(graphics::par(new=TRUE)); plot(x,y,
                                                        col ="antiquewhite1",
                                                        cex= 0.1 ,
                                                        xlim = c(0,upper_x ),ylim = c(0,upper_y),
                                                        xlab = paste('mean of cumulative false positives per image (', NI," images)"  ),
                                                        ylab = paste('mean of cumulative hit per lesion (', NL," lesions)"  )
                                                        ,main =title
        );
        # message("\n * In the plot plane, the AFROC curves emanate from origin (0,0) to (1,1).\n")
      }

      if(DrawFROCcurve==TRUE){


        #FROC
        suppressWarnings(graphics::par(new=TRUE)); plot(l,y,
                                                        col ="antiquewhite1",
                                                        bg="gray",
                                                        fg="gray",
                                                        xlab = paste('mean of cumulative false positives per image (', NI," images)"  ),
                                                        ylab = paste('mean of cumulative hit per lesion (', NL," lesions)"  ),
                                                        cex= 0.1,
                                                        xlim = c(0,upper_x ),
                                                        ylim = c(0,upper_y)
                                                        ,main = title

        );

      }


      if(DrawCFPCTP==TRUE){

        #CFP-CTP points
        # pchh <-paste(md);
        suppressWarnings(graphics::par(new=TRUE));plot(ff,hh,
                                                       xlim = c(0,upper_x ),
                                                       ylim = c(0,upper_y),
                                                       # col =1+(md-1)*Q+(qd-1),
                                                       # col =rgb(1/md,1/md,1/md),
                                                       bg="gray",
                                                       fg="gray",
                                                       col ="antiquewhite1",
                                                       # pch =paste(md),
                                                       cex=3,# Size of Dots
                                                       xlab = '', ylab = '')






      } # if DrawCFPCTP==TRUE
    }#  if(Drawcol==TRUE

  }# if(DrawCurve == TRUE ||DrawCurve == T ){

























  if(DrawCurve == FALSE  ||DrawCurve == F){
    if(summary==TRUE)  message(crayon::silver(" \n We de not draw the FROC and AFROC curves. \n"))
  }

  #   else{
  #   message(" \n DrawCurve is allowed only two choice; TRUE or FALSE. \n")
  # }





  #     if(summary ==TRUE){
  #   message("\n--------------------------------------------------  \n")
  #   message("* The goodness of fit chi-square statistic is equal to ",  signif(chisquare,digits = dig),". \n")
  #   message("\n* The representation of goodness of fit chi-square statistic is given in the Chakraborty's paper; Med Phys. 1989 Jul-Aug;16(4):561-8. Maximum likelihood analysis of free-response receiver operating characteristic (FROC) data. Chakraborty DP. It is also given in the author's paper.\n")
  #   message("--------------------------------------------------  \n")
  #   message("\n The expected a posterior estimate of the area under the FROC curve: \n \n ")
  #   pasteAUC <- paste("AUC =  ",  signif(summary(fit)$summary["A","mean"],digits = dig), " \n" )
  #   message(pasteAUC)
  #   message("\n The 95% Credible Interval of AUC := [ lower bound, upper bound] is the following:\n \n ")
  #   message("The 95%CI = [",signif( summary(fit)$summary["A","2.5%"],digits = dig), ",",signif(summary(fit)$summary["A","97.5%"],digits = dig), "]." )
  #   message("\n--------------------------------------------------  \n")
  # }




  fit.new.class <- methods::as(fit,"stanfitExtended")
  fit.new.class@metadata <-data
  fit.new.class@dataList <-dataList
  fit.new.class@studyDesign <-  "srsc.per.image"
  if(PreciseLogLikelihood==TRUE) {fit.new.class@WAIC <- waic(fit,dig,summary=FALSE)}
  fit.new.class@convergence    <-  convergence
  fit.new.class@chisquare <- chisquare

  fit.new.class@PreciseLogLikelihood    <-  PreciseLogLikelihood



  if(summary ==TRUE){
    summary_EAP_CI_srsc(
      StanS4class=fit.new.class,
      dig=dig
    )
  }#if
  extractAUC(
    StanS4class=fit.new.class,
    summary=summary,
    dig=dig
  )


  drawdata <- data.frame(x.AFROC =x,
                         y.AFROC=y,
                         x.FROC= l,
                         y.FROC=y )
  if(make.csv.file.to.draw.curve==TRUE){
    message("\n\n* Please wait ... now we launch two scv files to draw your FROC curve and cumulative hits and false alarms")
    #Launch the Draw data---START
    xlsx::write.xlsx (drawdata, paste(file.path(Sys.getenv("USERPROFILE"),"Desktop"),"/DrawData.xlsx", sep = ""),  col.names=TRUE, row.names=FALSE, append=FALSE, showNA=TRUE)
    message("* A DrawData.csv are created in your desktop. \n* Using this csv file, you can draw the FROC and AFROC curves by scatter plot.")
    drawTPFP <- data.frame(NumberOfCumulativeFalsePositives =ff,
                           NumberOfCumulativeTurePositives=hh)
    xlsx::write.xlsx (drawTPFP, paste(file.path(Sys.getenv("USERPROFILE"),"Desktop"),"/DrawPoints.xlsx",  sep = ""),col.names=TRUE, row.names=FALSE, append=FALSE, showNA=TRUE)
    message("\n* A DrawPoints.csv are created in your desktop. \n")
    message("\n* Using this csv file you can plot cumlative false positives and cumulative true positives by scatter plot.")
  }
  #Launch the Draw data---STOP
  fit.new.class@plotdata <-drawdata



  if(!sum(rstan::get_divergent_iterations(fit))==0){

    message("\n* Divergence:",    sum(rstan::get_divergent_iterations(fit)) )
    message("\n* Iterations:",    length(rstan::get_divergent_iterations(fit)) )# = cha*(ite-war)
    message("\n* Rate: ", 100*sum(rstan::get_divergent_iterations(fit))/length(rstan::get_divergent_iterations(fit)),"% \n")
  }


  fit.new.class@Divergences      <- sum(rstan::get_divergent_iterations(fit))
  fit.new.class@MCMC.Iterations       <- length(rstan::get_divergent_iterations(fit))
  fit.new.class@Divergence.rate  <- 100*sum(rstan::get_divergent_iterations(fit))/length(rstan::get_divergent_iterations(fit))
  if ( dataList.Name==""   ) dataList.Name <-  deparse(substitute(dataList))
  fit.new.class@dataList.Name <- dataList.Name

  if(summary ==TRUE){size_of_return_value(summary=summary,object =  fit.new.class)}
  invisible(fit.new.class)

}



#
# ll<- stats::rchisq(100, 1)
# lll<- 0.99+ll
# l<-append(ll,lll)
#
# x<- 1-exp(-l)
# y <- 1-stats::pnorm(0.3*stats::qnorm( exp(-l ) )-0.5)
#
# x <- c(0, x, 1)
# y <- c(0, y, 1)
#
# plot(x,y,xlim=c(0,1),ylim=c(0,1))
