% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrawCurves.R
\name{DrawCurves_MRMC_pairwise}
\alias{DrawCurves_MRMC_pairwise}
\title{Draw the FROC  curves with Colour}
\usage{
DrawCurves_MRMC_pairwise(StanS4class, modalityID, readerID,
  Colour = TRUE, DrawFROCcurve = TRUE, DrawAFROCcurve = FALSE,
  DrawCFPCTP = TRUE, Draw.Flexible.upper_y = TRUE,
  Draw.Flexible.lower_y = TRUE, new.imaging.device = TRUE,
  summary = TRUE, color_is_changed_by_each_reader = FALSE, type = 1)
}
\arguments{
\item{StanS4class}{An S4 object of class \emph{\code{ \link{stanfitExtended}}} which is an inherited class from the S4 class  \code{\link[rstan]{stanfit}}  that can be passed to the \code{\link{DrawCurves}()}, \code{\link{ppp}()}  and ... etc}

\item{modalityID}{This is a vector indicating modalityID whose component is natural namber.}

\item{readerID}{This is a vector indicating readerID whose component is natural namber.}

\item{Colour}{Logical, that is \code{TRUE} or \code{FALSE}. Whether plot  of curves are with dark theme. Default is \code{TRUE} indicating dark theme.}

\item{DrawFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether  the FROC curve  is to be drawn.}

\item{DrawAFROCcurve}{Logical: \code{TRUE} of \code{FALSE}. Whether the  AFROC curve is to be drawn.}

\item{DrawCFPCTP}{Logical: \code{TRUE} of \code{FALSE}. Whether  the CFPCTP points are  to be drawn.}

\item{Draw.Flexible.upper_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the upper bounds of vertical axis are determined automatically.}

\item{Draw.Flexible.lower_y}{Logical, that is \code{TRUE} or \code{FALSE}. Whether or not the lower bounds of vertical axis are determined automatically.}

\item{new.imaging.device}{Logical: \code{TRUE} of \code{FALSE}. If TRUE (default), then open a new device to draw curve.
Using this we can draw curves in same plain by new.imaging.device=FALSE.}

\item{summary}{Logical: \code{TRUE} of \code{FALSE}. Whether to print the verbose summary, i.e., logical; If \code{TRUE} then verbose summary is printed in the \R console. If \code{FALSE}, the output is minimal. I regret, this variable name should be verbose.}

\item{color_is_changed_by_each_reader}{A logical, if \code{TRUE}, then the FROC curves, AFROC curves, and FPF, TPF are colored accordingly by each reader. The aim of FROC analysis is to compare the modality and not reader, so the default value is false, and curves and FPF and TPF are colored by each modalities.}

\item{type}{An integer, for the color of background and etc.}
}
\description{
Draw  \emph{FROC  curves} and \emph{AFROC curves} for user's specified modalities and user's specified readers.
Using this function \emph{\strong{repeatedly}}, we can draw the different reader and modality in a  \emph{\strong{same}} plane simultaneously.
}
\details{
By drawing different modality FROC curves in the same plane, we can compare the modality.
E.g., if some modality FROC curve is \code{upper} then other modality curves,
 then we may say that the upper modality is \code{better} observer performance, i.e., higher AUC.
}
\examples{

\donttest{
#1) Build the S4 class object by the following:



  fit <- fit_Bayesian_FROC(dataList.Chakra.Web)


# The object "fit" is an S4 class object
# whose S4 class name is stanfit in the rstan package.

#<<Minor comments>>
#Note that return value "fit" is not an stanfit S4 object generated by rstan::stan(),
#but some inherited S4 class object which is an S4 object of
# some inherited S4 class from stanfit class. So, we can consider it as an object of
#an S4 class of rstan::stan().
#2) Now, we obtain the S4 class object named "fit".
  # Using this S4 class object, we draw the curves by:



 DrawCurves_MRMC_pairwise(fit,
                          modality = 1,
                          reader = 4
                          )



#3) By changing, e.g., the modality,
   #we can draw the curves for different  modalities.
   #This shows the comparison of modalites.



 DrawCurves_MRMC_pairwise(fit,
                          modality = 2,
                          reader = 4
                          )

 DrawCurves_MRMC_pairwise(fit,
                          modality = 3,
                          reader = 4
                          )


#4) By repeat the running with respect to different modalities
#   in this manner, we can draw  AFROC (FROC) curves.



#5) If you want to draw the FROC curves
#for reader ID =1,2,3,4 and modality ID =1,2, then the code is as follows;

DrawCurves_MRMC_pairwise(
                            fit,
                            modalityID = c(1,2,3,4),
                            readerID = c(1,2)
                            )
# Each color of curves corresponds to the modality ID.
# So, even if curves are different readers and same modality, then color is same.














       #   Close the graphic device
           Close_all_graphic_devices()
       } # dottest
}
\author{
Issei Tsunoda
}
