% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argMax.R
\name{argMin}
\alias{argMin}
\title{Arg Min: Extract a subscript corresponding component is a minimal}
\usage{
argMin(numeric_vector, verbose = FALSE)
}
\arguments{
\item{numeric_vector}{A vector, each component is a real number (an object of class numeric).}

\item{verbose}{A logical, if TRUE, then verbose summary is printed in R or R studio console.}
}
\value{
A non-negative integer, indicating a subscript, corresponding component is the maximum component.
}
\description{
The non-negative valued function of a vector, which returns
a subscript whose component is the minimal component of the vector.
Namely,

\code{argMin(vector) = i}

 if and only if

   \code{vector[i] <= vector[j]} for all \code{j}.
}
\details{
This function is very fundamental and so,,,
Is there a same function in the package \pkg{base}?
}
\examples{

     argMin(c(11,99,99,99,99,99,99,99,99,99))
     argMin(c(99,22,99,99,99,99,99,99,99,99))
     argMin(c(99,99,33,99,99,99,99,99,99,99))
     argMin(c(99,99,99,44,99,99,99,99,99,99))
     argMin(c(99,99,99,99,55,99,99,99,99,99))
     argMin(c(99,99,99,99,99,66,99,99,99,99))
     argMin(c(99,99,99,99,99,99,77,99,99,99))
     argMin(c(99,99,99,99,99,99,99,88,99,99))
     argMin(c(99,99,99,99,99,99,99,99,99,99))

     argMin(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(11,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,22,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,33,NaN,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,NaN,44,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,NaN,NaN,55,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,NaN,NaN,NaN,66,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,NaN,NaN,NaN,NaN,77,NaN,NaN,NaN))
     argMin(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,88,NaN,NaN))
     argMin(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,99,NaN))
     argMin(c(NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,NaN,100))


     argMin(c(NaN,NaN,NaN,22,NaN,55,NaN,NaN,NaN,NaN))
     argMin(c(NaN,44,NaN,11,NaN,NaN,NaN,NaN,NaN,NaN))
     argMin(c(NaN,NaN,33, 33, 33, 33,NaN,NaN,NaN,NaN))

}
\seealso{
\code{ \link{argMax}()}
}
