% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_GUI_Shiny.R
\name{fit_GUI_Shiny}
\alias{fit_GUI_Shiny}
\title{Fit a model with GUI of Shiny}
\usage{
fit_GUI_Shiny(
  DF = data.frame(f = c(1L, 14L, 74L), h = c(97L, 32L, 31L)),
  NL.initial = 259L,
  NI.initial = 57L,
  samples_from_likelihood_for_ppp.initial = 5L,
  samples_from_likelihood_for_ppp.max = 111L,
  NL.min = 1L,
  NL.max = 1111L,
  NI.max = 1111L,
  width_of_data_input_panel = 555L,
  MCMC_iterations_love.initial = 1111L,
  min_MCMC_iterations_love.initial = 22L,
  max_MCMC_iterations_love.initial = 11111L,
  seed.MCMC.max = 111111L,
  Seed_of_MCMC_love.initial = 1234L,
  parallel_MCMC_chains_love.initial = 1L,
  ww.initial = -11,
  www.initial = 11,
  mm.initial = 0.65,
  mmm.initial = 11,
  vv.initial = 5.31,
  vvv.initial = 11,
  zz.initial = 1.55,
  zzz.initial = 11,
  DF_NL = data.frame(NL.initial = NL.initial),
  DF_NI = data.frame(NI.initial = NI.initial),
  DF_samples_from_likelihood = data.frame(samples_from_likelihood_for_ppp.initial =
    samples_from_likelihood_for_ppp.initial),
  print_debug = FALSE,
  MCMC.chains.max = parallel::detectCores()
)
}
\arguments{
\item{DF}{A dataframe as an initial data to be fitted a model}

\item{NL.initial}{Natural number indicating the initial number of lesions, Default value =259.}

\item{NI.initial}{Natural number indicating the initial number of images, Default value =57}

\item{samples_from_likelihood_for_ppp.initial}{initial value of number of samples}

\item{samples_from_likelihood_for_ppp.max}{maximal value of samples}

\item{NL.min}{min number of bins indicating the minimal number in which the number of lesions can move}

\item{NL.max}{max number of bins indicating the maximal number in which the number of lesions can move}

\item{NI.max}{max number of bins indicating the maximal number in which the number of imagegs can move}

\item{width_of_data_input_panel}{width of data panel}

\item{MCMC_iterations_love.initial}{Natural number indicating the initial number of MCMC samplings, Default value = 1111L}

\item{min_MCMC_iterations_love.initial}{Natural number indicating the initial minimum number of MCMC samplings, Default value =333}

\item{max_MCMC_iterations_love.initial}{Natural number indicating the initial maximal number of MCMC samplings, Default value =333}

\item{seed.MCMC.max}{Natural number indicating the initial possible maximal seed of MCMC samplings, Default value =111111}

\item{Seed_of_MCMC_love.initial}{Natural number indicating the initial number of MCMC samplings, Default value =1234L}

\item{parallel_MCMC_chains_love.initial}{Natural number indicating the initial number of MCMC samplings, Default value =333}

\item{ww.initial, www.initial, mm.initial, mmm.initial, vv.initial, vvv.initial, zz.initial, zzz.initial}{parameters for prior}

\item{DF_NL}{A data-frame, consisting of a positive number representing the number of lesions}

\item{DF_NI}{A data-frame, consisting of a positive number representing the number of images}

\item{DF_samples_from_likelihood}{auxilary data frame for samples}

\item{print_debug}{A logical, whether debug messages are printed or not. In Shiny, initial values can be specified. However, it dose not work correctly for me. Thus, I examine what values are passed .... so this variable used for the treatments of initial values, mainly.}

\item{MCMC.chains.max}{max number of bins indicating number of MCMC chains}
}
\value{
In global environment, \R object named "f" and "d" are

In global environment, an \R object named "f" is created, in which fitted model object is included. This is not return value, you know, cuz
 \code{.Last.value} is not the object "f". However, you know, for the pretty cute, it is sufficient.

 In global environment, an \R object named "d" is created, which is the dataset to which the model is fitted.
}
\description{
A graphical user interface (GUI) to fit a model to data.
}
\details{
First, please execute, then user will understand what it is.
This function is the one of the most important function in this package.
I do not assume that the user is familiar with R script but FROC analysis.
 So, I made this function to provide
  the Graphical User Interface (GUI) for users to avoid CUI (Characteristic User Interface).
 The GUI is made by the \pkg{shiny} package.
}
\examples{

## Only run examples in interactive R sessions
if (interactive()) {
#========================================================================================
#            1)           Use the default User Interface
#========================================================================================
#'

#No need to consider the variables, it is sufficient in  default values.


 fit_GUI_Shiny()




#========================================================================================
#            2)           Change the  User Interface
#========================================================================================


#  We can change the max imput of the number of lesions and the max of number of images
#

 fit_GUI_Shiny(NL.max = 2222,
                NI.max = 3333)





#========================================================================================
#            3)           Change the  Default value
#========================================================================================



  fit_GUI_Shiny(
            DF= data.frame(
            f = c(  8,  16,  18,  13),
            h = c(160,  25,  15,   7)
                         )
            )






#    Note that the following is wrong



  fit_GUI_Shiny(
            DF= data.frame(
            h = c(160,  25,  15,   7),
            f = c(  8,  16,  18,  13)
                         )
            )








#========================================================================================
#            4)           Change the user Imterface
#========================================================================================



     fit_GUI_Shiny(

          DF= data.frame(
            f = c(  8,  16,  18,  13),
            h = c(160,  25,  15,   7)
                ),

                NL.max = 1192,
                NI.max = 794,
                MCMC.chains.max = 6

              )





#========================================================================================
#            5) CUI rather than GUI input
#========================================================================================


#              How to input data using CUI?
#                           This example gives an answer.
#

# CUI:  Characteristic user interface


# Here, I show the very strange data, that is, the number of hits is all 33
# and replicated 10 times, that is,
# h is substituted by rep(33L,10) indicating  33 33 33 33 33 33 33 33 33 33
# f is also same as h.




  fit_GUI_Shiny(NL.initial=555,
               DF =data.frame(
                 f= as.integer(rep(33,10)),
                 h= as.integer(rep(33,10))
               )
 )


# The author made this example since, when I check my program,
# such as whether the color used in polygon() is appropriate or not.

# If user thinks that it is very hard to input hits and false alarms
# by GUI manner, then use this characteristic manner.

















#========================================================================================
#            6) Change maximul possible number of chains
#========================================================================================


# We can generate at most 8 chains in MCMC sampling


    fit_GUI_Shiny(  MCMC.chains.max = 8 )






}### Only run examples in interactive R sessions

}
