% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposalGenerator.R
\name{createProposalGenerator}
\alias{createProposalGenerator}
\title{Factory that creates a proposal generator}
\usage{
createProposalGenerator(covariance, gibbsProbabilities = NULL,
  gibbsWeights = NULL, otherDistribution = NULL,
  otherDistributionLocation = NULL, otherDistributionScaled = F,
  message = F, method = "chol", scalingFactor = 2.38)
}
\arguments{
\item{covariance}{covariance matrix. Can also be vector of the sqrt of diagonal elements --> standard deviation}

\item{gibbsProbabilities}{optional probabilities for the number of parameters to vary in a Metropolis within gibbs style - for 4 parameters, c(1,1,0.5,0) means that at most 3 parameters will be varied, and it is double as likely to vary one or two than varying 3}

\item{gibbsWeights}{optional probabilities for parameters to be varied in a Metropolis within gibbs style - default ist equal weight for all parameters - for 4 parameters, c(1,1,1,100) would mean that if 2 parameters would be selected, parameter 4 would be 100 times more likely to be picked than the others. If 4 is selected, the remaining parameters have equal probability.}

\item{otherDistribution}{optional additinal distribution to be mixed with the default multivariate normal. The distribution needs to accept a parameter vector (to allow for the option of making the distribution dependend on the parameter values), but it is still assumed that the change from the current values is returned, not the new absolute values.}

\item{otherDistributionLocation}{a vector with 0 and 1, denoting which parameters are modified by the otherDistribution}

\item{otherDistributionScaled}{should the other distribution be scaled if gibbs updates are calculated?}

\item{message}{print out parameter settings}

\item{method}{method for covariance decomposition}

\item{scalingFactor}{scaling factor for the proposals}
}
\description{
Factory that creates a proposal generator
}
\examples{
testMatrix = matrix(rep(c(0,0,0,0), 1000), ncol = 4)
testVector = c(0,0,0,0)


##Standard multivariate normal proposal generator

testGenerator <- createProposalGenerator(covariance = c(1,1,1,1), message = TRUE)

methods(class = "proposalGenerator")
print(testGenerator)

x = testGenerator$returnProposal(testVector)
x

x <- testGenerator$returnProposalMatrix(testMatrix)
boxplot(x)

##Changing the covariance
testGenerator$covariance = diag(rep(100,4))
testGenerator <- testGenerator$updateProposalGenerator(testGenerator, message = TRUE)

testGenerator$returnProposal(testVector)
x <- testGenerator$returnProposalMatrix(testMatrix)
boxplot(x)


##-Changing the gibbs probabilities / probability to modify 1-n parameters

testGenerator$gibbsProbabilities = c(1,1,0,0)
testGenerator <- testGenerator$updateProposalGenerator(testGenerator)

testGenerator$returnProposal(testVector)
x <- testGenerator$returnProposalMatrix(testMatrix)
boxplot(x)


##-Changing the gibbs weights / probability to pick each parameter

testGenerator$gibbsWeights = c(0.3,0.3,0.3,100)
testGenerator <- testGenerator$updateProposalGenerator(testGenerator)

testGenerator$returnProposal(testVector)
x <- testGenerator$returnProposalMatrix(testMatrix)
boxplot(x)


##-Adding another function

otherFunction <- function(x) sample.int(10,1)

testGenerator <- createProposalGenerator(
  covariance = c(1,1,1), 
  otherDistribution = otherFunction, 
  otherDistributionLocation = c(0,0,0,1),
  otherDistributionScaled = TRUE
)

testGenerator$returnProposal(testVector)
x <- testGenerator$returnProposalMatrix(testMatrix)
boxplot(x)
table(x[,4])
}
\seealso{
\code{\link{updateProposalGenerator}}
}
\author{
Florian Hartig
}
