/*
 * Decompiled with CFR 0.152.
 */
package dr.math.iterations;

import dr.math.interfaces.OneVariableFunction;
import dr.math.iterations.FunctionalIterator;

public class BisectionZeroFinder
extends FunctionalIterator {
    private double xNeg;
    private double xPos;

    public BisectionZeroFinder(OneVariableFunction oneVariableFunction) {
        super(oneVariableFunction);
    }

    public BisectionZeroFinder(OneVariableFunction oneVariableFunction, double d, double d2) throws IllegalArgumentException {
        this(oneVariableFunction);
        this.setNegativeX(d);
        this.setPositiveX(d2);
    }

    @Override
    public double evaluateIteration() {
        this.result = (this.xPos + this.xNeg) * 0.5;
        if (this.f.value(this.result) > 0.0) {
            this.xPos = this.result;
        } else {
            this.xNeg = this.result;
        }
        return this.relativePrecision(Math.abs(this.xPos - this.xNeg));
    }

    public void setNegativeX(double d) throws IllegalArgumentException {
        if (this.f.value(d) > 0.0) {
            throw new IllegalArgumentException("f(" + d + ") is positive instead of negative");
        }
        this.xNeg = d;
    }

    public void setPositiveX(double d) throws IllegalArgumentException {
        if (this.f.value(d) < 0.0) {
            throw new IllegalArgumentException("f(" + d + ") is negative instead of positive");
        }
        this.xPos = d;
    }
}

