/*
 * Decompiled with CFR 0.152.
 */
package dr.math.matrixAlgebra;

import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedMatrix;
import dr.math.matrixAlgebra.WrappedVector;

public interface ReadableMatrix
extends ReadableVector {
    public double get(int var1, int var2);

    public int getMajorDim();

    public int getMinorDim();

    public static class Utils {
        public static double[] toArray(ReadableMatrix readableMatrix) {
            double[] dArray = new double[readableMatrix.getDim()];
            int n = 0;
            for (int i = 0; i < readableMatrix.getMajorDim(); ++i) {
                for (int j = 0; j < readableMatrix.getMinorDim(); ++j) {
                    dArray[n] = readableMatrix.get(i, j);
                    ++n;
                }
            }
            return dArray;
        }

        public static WrappedVector product(ReadableMatrix readableMatrix, ReadableVector readableVector) {
            int n = readableMatrix.getMajorDim();
            int n2 = readableMatrix.getMinorDim();
            assert (readableVector.getDim() == n2);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                double d = 0.0;
                for (int j = 0; j < n2; ++j) {
                    d += readableMatrix.get(i, j) * readableVector.get(j);
                }
                dArray[i] = d;
            }
            return new WrappedVector.Raw(dArray);
        }

        public static ReadableMatrix transposeProxy(final ReadableMatrix readableMatrix) {
            return new ReadableMatrix(){

                @Override
                public double get(int n, int n2) {
                    return readableMatrix.get(n2, n);
                }

                @Override
                public int getMajorDim() {
                    return readableMatrix.getMinorDim();
                }

                @Override
                public int getMinorDim() {
                    return readableMatrix.getMajorDim();
                }

                @Override
                public double get(int n) {
                    throw new RuntimeException("Not yet implemented");
                }

                @Override
                public int getDim() {
                    return readableMatrix.getDim();
                }
            };
        }

        public static ReadableMatrix productProxy(final ReadableMatrix readableMatrix, final ReadableMatrix readableMatrix2) {
            final int n = readableMatrix.getMajorDim();
            final int n2 = readableMatrix.getMinorDim();
            final int n3 = readableMatrix2.getMinorDim();
            assert (n2 == readableMatrix2.getMajorDim());
            return new ReadableMatrix(){

                @Override
                public double get(int n4, int n22) {
                    double d = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        d += readableMatrix.get(n4, i) * readableMatrix2.get(i, n22);
                    }
                    return d;
                }

                @Override
                public int getMajorDim() {
                    return n;
                }

                @Override
                public int getMinorDim() {
                    return n3;
                }

                @Override
                public double get(int n4) {
                    return this.get(n4 / n3, n4 % n3);
                }

                @Override
                public int getDim() {
                    return n * n3;
                }

                public String toString() {
                    return WrappedMatrix.Utils.makeString(this);
                }
            };
        }

        public static WrappedVector product(ReadableMatrix readableMatrix, ReadableMatrix readableMatrix2) {
            int n = readableMatrix.getMajorDim();
            int n2 = readableMatrix.getMinorDim();
            int n3 = readableMatrix2.getMinorDim();
            assert (n2 == readableMatrix2.getMajorDim());
            double[] dArray = new double[n * n3];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        d += readableMatrix.get(i, k) * readableMatrix2.get(k, j);
                    }
                    dArray[i * n3 + j] = d;
                }
            }
            return new WrappedVector.Raw(dArray);
        }
    }
}

