/*
 * Decompiled with CFR 0.152.
 */
package jebl.util;

import java.util.Arrays;

public class FixedBitSet {
    int[] bits;
    int size;
    private static final int ADDRESS_BITS_PER_UNIT = 5;
    private static final int BITS_PER_UNIT = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final byte[] firstBitLocation = new byte[]{-1, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private int countBits(int b) {
        int sum = 0;
        while (b != 0) {
            b &= b - 1;
            ++sum;
        }
        return sum;
    }

    private static int bit(int bitIndex) {
        return 1 << (bitIndex & 0x1F);
    }

    public FixedBitSet(int size) {
        this.size = size;
        this.bits = new int[FixedBitSet.unitIndex(size - 1) + 1];
    }

    public FixedBitSet(FixedBitSet bs) {
        this.bits = (int[])bs.bits.clone();
        this.size = bs.size;
    }

    public void set(int position) {
        int unitIndex;
        int n = unitIndex = FixedBitSet.unitIndex(position);
        this.bits[n] = this.bits[n] | FixedBitSet.bit(position);
    }

    public void clear(int position) {
        int unitIndex;
        int n = unitIndex = FixedBitSet.unitIndex(position);
        this.bits[n] = this.bits[n] & ~FixedBitSet.bit(position);
    }

    public boolean setInclusion(FixedBitSet bitset) {
        for (int k = 0; k < this.bits.length; ++k) {
            if (this.bits[k] == (this.bits[k] & bitset.bits[k])) continue;
            return false;
        }
        return true;
    }

    public void union(FixedBitSet b) {
        for (int k = 0; k < Math.min(this.bits.length, b.bits.length); ++k) {
            int n = k;
            this.bits[n] = this.bits[n] | b.bits[k];
        }
    }

    public void intersect(FixedBitSet b) {
        for (int k = 0; k < Math.min(this.bits.length, b.bits.length); ++k) {
            int n = k;
            this.bits[n] = this.bits[n] & b.bits[k];
        }
    }

    public void setMinus(FixedBitSet b) {
        for (int k = 0; k < Math.min(this.bits.length, b.bits.length); ++k) {
            int n = k;
            this.bits[n] = this.bits[n] & ~b.bits[k];
        }
    }

    public int intersectCardinality(FixedBitSet b) {
        int c = 0;
        for (int k = 0; k < Math.min(this.bits.length, b.bits.length); ++k) {
            c += this.countBits(this.bits[k] & b.bits[k]);
        }
        return c;
    }

    public static FixedBitSet complement(FixedBitSet b) {
        FixedBitSet t = new FixedBitSet(b);
        t.complement();
        return t;
    }

    public void complement() {
        int k;
        for (k = 0; k < this.bits.length - 1; ++k) {
            this.bits[k] = ~this.bits[k];
        }
        this.bits[k] = ~this.bits[k];
        int mask = FixedBitSet.bit(this.size) - 1;
        if (mask != 0) {
            int n = k;
            this.bits[n] = this.bits[n] & mask;
        }
    }

    private int firstOnBit(int i) {
        for (int k = 0; k < 4; ++k) {
            char b = (char)(i & 0xFF);
            if (b != '\u0000') {
                return 8 * k + firstBitLocation[b];
            }
            i >>= 8;
        }
        return -1;
    }

    public int nextOnBit(int fromIndex) {
        int testIndex;
        int u = FixedBitSet.unitIndex(fromIndex);
        int unit = this.bits[u] >> (testIndex = fromIndex & 0x1F);
        if (unit == 0) {
            testIndex = 0;
            while (unit == 0 && u < this.bits.length - 1) {
                unit = this.bits[++u];
            }
        }
        if (unit == 0) {
            return -1;
        }
        return u * 32 + (testIndex += this.firstOnBit(unit));
    }

    public int cardinality() {
        int sum = 0;
        for (int b : this.bits) {
            sum += this.countBits(b);
        }
        return sum;
    }

    public boolean contains(int i) {
        int unitIndex = FixedBitSet.unitIndex(i);
        return (this.bits[unitIndex] & FixedBitSet.bit(i)) != 0;
    }

    public int hashCode() {
        int code = 0;
        for (int bit : this.bits) {
            code ^= bit;
        }
        return code;
    }

    public boolean equals(Object x) {
        if (x instanceof FixedBitSet) {
            FixedBitSet b = (FixedBitSet)x;
            return b.size == this.size && Arrays.equals(this.bits, b.bits);
        }
        return false;
    }

    public String toString() {
        StringBuilder rep = new StringBuilder();
        rep.append("{");
        for (int b = 0; b < this.size; ++b) {
            if (!this.contains(b)) continue;
            if (rep.length() > 0) {
                rep.append("," + b);
                continue;
            }
            rep.append("" + b);
        }
        rep.append("}");
        return rep.toString();
    }
}

