% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{regression}
\alias{regression}
\title{The Regression Game}
\usage{
regression(...)
}
\arguments{
\item{...}{\code{regression} function is called with different arguments, which
vary depending on a problem that Beta and Bit are trying to solve. See
\code{Details} in order to learn more about the list of possible arguments.}
}
\value{
Function returns one of three possible values:
\itemize{
  \item{\code{TRUE} if you provided correct answer to a task,}
  \item{\code{FALSE} if you provided wrong answer to a task,}
  \item{\code{NULL} if function can't identify task you wanted to answer.}
}
}
\description{
The \code{regression} function is used for solving problems in the data-based
game ,,The regression Game''.
}
\details{
Every time when some additional hints are needed one should add
\code{hint = TRUE} or \code{techHint = TRUE} argument to the \code{regression} function.
Technical hints will point out R packages and/or functions which might help
you to solve the task while "normal" hints provide you with methodological
advices.

In this game you are helping Professor Pearson.
You can communicate with him through the \code{regression} function.

In each call include the \code{subject} parameter (indicating which task
you are trying to answer) and the \code{content} parameter (providing
information Professor Pearson is asking you for in a given task).

Data used in the game comes from the study of Polish upper-secondary
schools first grade students. It was conducted together with the
PISA 2009 study using the same cognitive tests and questionnaires as
in PISA 2009 but on a different group of students (in Poland most of the
students in a PISA sample attends lower-secondary schools). The students who
participated in the first wave of the study were followed in the 2nd grade of
upper-secondary school within the research program \emph{Our further study
and work} (\emph{Nasza Dalsza Nauka i Praca}). Both studies were conducted by
the Institute of Philosophy and Sociology Polish Academy of Sciences.
\strong{The original data was changed a little, to better fit the purpose of
the game.}

,,The Regression Game'' is a free of charge, educational project of the
SmarterPoland.pl Foundation.
}
\examples{
regression()
regression(hint = TRUE)
regression(techHint = TRUE)
}
\author{
\itemize{
  \item{Tomasz Zoltak - the idea and the implementation,}
  \item{Mateusz Zoltak - comments, contribution to hints,}
  \item{Zuzanna Brzozowska - proofreading,}
  \item{Przemyslaw Biecek - comments and the integration with the `BetaBit` package.}
}
}

