% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bevimed}
\alias{bevimed}
\title{Perform inference under model variant-level model v for y using MCMC sampling}
\usage{
bevimed(y, G, min_ac = 1L, q_shape = c(2, 100), p_shape = c(10, 2),
  omega_shape = if (min_ac == 1L) c(2, 9) else c(2, 2),
  samples_per_chain = 2000, stop_early = FALSE, max_samples = 5000,
  burn = as.integer(samples_per_chain/10), temperatures = (0:10/10)^2,
  tune_temperatures = 0, marginal_likelihood_only = FALSE,
  store_Z = !marginal_likelihood_only,
  swaps = as.integer(length(temperatures)/2), optimise_Z0 = FALSE,
  tune_omega_and_phi_proposal_sd = FALSE, tune_block_size = 100,
  variant_weights = NULL, estimate_phi = !is.null(variant_weights),
  log_phi_mean = -1.5, log_phi_sd = 1, tandem_variant_updates = if (min_ac
  == 1) 0 else sum(y), ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{G}{Integer matrix of variant counts per individual, one column per individual and one row per variant.}

\item{min_ac}{Minimum allele count per individual to be considered to have a pathogenic combination of variants. '1' could correspond to a dominant inheritance hypothesis whereas '2' could correspond to a recessive inheritance hypothesis.}

\item{q_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with non-pathogenic variant combinations (i.e. they have less than \code{min_ac} variants.}

\item{p_shape}{Beta shape hyper-priors for prior on rate of affection (i.e. being a case) amongst individuals with pathogenic variant combinations (i.e. they have at least \code{min_ac} variants.}

\item{omega_shape}{Beta shape hyper-priors for prior on rate of pathogenicity amongst variants.}

\item{samples_per_chain}{Number of samples to draw from each chain.}

\item{stop_early}{Logical value determining whether to attempt to stop the sampling as soon as certain conditions are met (i.e. either the estimated marginal log likelihood lies within a certain confidence interval, or we are sufficiently confidence that the log Bayes factor against the null model is sufficiently low).}

\item{max_samples}{Maximum number of samples to take before terminating the sampling.}

\item{burn}{Number of samples to drop from the start of the chain.}

\item{temperatures}{Numeric vector of temperatures of power posteriors. One chain will be created for each element of the vector at the corresponding temperature.}

\item{tune_temperatures}{Integer value - if greater than 0, the \code{temperatures} argument is ignored, and instead \code{tune_temperatures} tuned temperatures are used instead.}

\item{marginal_likelihood_only}{Logical value determining whether to only return the estimated log marginal likelihood of the data under v as a numeric value, or to return an object of class \code{BeviMed} containing the full output of the MCMC sampling routine.}

\item{store_Z}{Logical value determining whether to store the Z-vectors for each chain, which uses alot of memory, particularly if \code{samples_per_chain}, k and \code{length(temperatures)} are high.}

\item{swaps}{Number of swaps between adjacent tempered chains to perform per update cycle.}

\item{optimise_Z0}{Logical value determining whether to use a simulated annealing optimisation run to tune the initial values of \code{Z}.}

\item{tune_omega_and_phi_proposal_sd}{Logical value determining whether the proposal SDs of the Metropolis-Hastings estimated parameters should be tuned for a target acceptance range (see \code{\link{tune_proposal_sds}},}

\item{tune_block_size}{Integer value giving number of samples to draw when estimatating the acceptance rate of the omega/phi proposals in call to \code{\link{tune_proposal_sds}}.}

\item{variant_weights}{Vector of log-odds off-sets for rates of pathogenicity of individual variants relative to the global rate, omega.}

\item{estimate_phi}{Logical value determining whether to estimate a scaling factor of \code{variant_weights}.}

\item{log_phi_mean}{Mean for normal prior on scaling factor phi.}

\item{log_phi_sd}{SD for normal prior on scaling factor phi.}

\item{tandem_variant_updates}{Number of tandem variant updates to make per update cycle.}

\item{...}{Other arguments to be passed to \code{\link{stop_chain}} and/or \code{\link{tune_proposal_sds}}.}
}
\value{
If \code{marginal_likelihood_only == TRUE}, then a numeric value giving the log marginal likelihood, otherwise an object of class \code{BeviMed}.
}
\description{
This function is the main user-interface to the underlying c++ MCMC sampling routine.
}

