% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{stop_chain}
\alias{stop_chain}
\title{Apply the MCMC algorithm in blocks until conditions are met}
\usage{
stop_chain(y, blocks_remaining, start_Zs, start_logit_omegas, start_log_phis,
  temperatures, tolerance = 1, confidence = 0.95, simulations = 1000,
  marginal_likelihood_only = TRUE,
  quit_if_highest_possible_BF_less_than = -Inf,
  y_log_lik_t_equals_1_traces = matrix(ncol = length(temperatures), nrow = 0),
  full_block_traces = list(), verbose = FALSE, ...)
}
\arguments{
\item{y}{Logical vector of case (\code{TRUE}) control (\code{FALSE}) status.}

\item{blocks_remaining}{Maximum number of blocks left before termination.}

\item{start_Zs}{Initial (logical) Z-matrix.}

\item{start_logit_omegas}{Initial values of logit_omega (numeric vector - one value per chain).}

\item{start_log_phis}{Initial values of log_phi (numeric vector - one value per chain).}

\item{temperatures}{Numeric vector of temperatures of power posteriors. One chain will be created for each element of the vector at the corresponding temperature.}

\item{tolerance}{Maximum width for confidence_interval of log marginal likelihood to allow before stopping the chain.}

\item{confidence}{Numeric value of statistical confidence with which returning interval should contain the true value.}

\item{simulations}{Integer value of number of simulations to use in estimation of the confidence interval.}

\item{marginal_likelihood_only}{Logical value determining whether to only return the estimated log marginal likelihood of the data under v as a numeric value, or to return an object of class \code{BeviMed} containing the full output of the MCMC sampling routine.}

\item{quit_if_highest_possible_BF_less_than}{Numeric value used to determine whether to stop the sampling after consecutive blocks. If we are confident (to the extent given by the parameter \code{confidence}) that log Bayes factor of v against n is under this value, we stop the sampling as soon as possible.}

\item{y_log_lik_t_equals_1_traces}{Numeric matrix of log probabilities of \code{y} at different temperatures (columns) in different iterations (rows).}

\item{full_block_traces}{List of outputs of calls to MCMC routine.}

\item{verbose}{To print execution progress or not.}

\item{...}{Other arguments passed to \code{\link{call_cpp}}}
}
\value{
If \code{marginal_likelihood_only == TRUE}, then a numeric value giving the log marginal likelihood, otherwise an object of class \code{BeviMed}.
}
\description{
Sample blocks of a given size until either the estimated log marginal likelihood falls within a given confidence interval, there is sufficient confidence that the log Bayes factor over the null model is at most a certain quantity, or a certain number of blocks have been sampled.
}

