% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tune_proposal_sds}
\alias{tune_proposal_sds}
\title{Tune the proposal standard deviations for the Metropolis-Hastings updates of either phi or omega}
\usage{
tune_proposal_sds(tune_for = c("logit_omega", "log_phi"),
  initial_proposal_sds, target_acceptance_range = c(0.3, 0.7),
  other_param_proposal_sd = 0.7, max_tuning_cycles = 10, initial_rate = 1,
  rate_decay = 1.2, verbose = FALSE, ...)
}
\arguments{
\item{tune_for}{Character vector, where only the first element is used, determining which variable to tune the proposal SDs for.}

\item{initial_proposal_sds}{Numeric vector with the initial values of the proposal SDs.}

\item{target_acceptance_range}{Numeric vector of length 2 where the first element is the lower bound for the acceptance interval and the second is the upper bound.}

\item{other_param_proposal_sd}{The proposal SD to use for \code{log_phi} when tuning \code{logit_omega} or vice versa.}

\item{max_tuning_cycles}{Maximum number of tuning cycles to perform before returning the proposal SDs as they are.}

\item{initial_rate}{Initial rate at which to mutate the proposal SDs.}

\item{rate_decay}{Geometric rate of decay for size of proposal SD mutation with each successive tuning cycle.}

\item{verbose}{To print execution progress or not.}

\item{...}{Other arguments to be passed to \code{\link{call_cpp}}.}
}
\value{
Numeric vector of proposal SDs for the different temperature chains.
}
\description{
Tune the proposal standard deviations for the Metropolis-Hastings updates of either phi or omega
}

