% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{summary.BeviMed_m}
\alias{summary.BeviMed_m}
\title{Summarise a \code{BeviMed_m} object}
\usage{
\method{summary}{BeviMed_m}(object, confidence = 0.95, simulations = 1000,
  ...)
}
\arguments{
\item{object}{Object of class \code{BeviMed_m}. See function \code{\link{bevimed_m}}.}

\item{confidence}{Numeric value of statistical confidence with which returning interval should contain the true value.}

\item{simulations}{Integer value of number of simulations to use in estimation of the confidence interval.}

\item{...}{Unused arguments.}
}
\value{
Object of class \code{BeviMed_m_summary}.
}
\description{
Create a summary of inference conditional on mode of inheritance.
}
\details{
Returns a \code{BeviMed_m_summary} object, which is a list containing elements:
\itemize{
\item `gamma1_evidence': the log evidence under model gamma = 1,
\item `gamma1_evidence_confidence_interval': a confidence interval for the log evidence under model gamma = 1,
\item `conditional_prob_pathogenic': vector of marginal probabilities of pathogenicity for individual variants,
\item `expected_explained': the expected number of cases with a pathogenic configuration of alleles,
\item `explaining_variants': the expected number of variants present for which cases harbour a rare allele,
\item `number_of_posterior_samples': the number of samples from the posterior distribution of the model parameters which upon which the summary is based,
\item `omega_estimated': logical value indicating whether the parameter omega was estimated,
\item `omega': the posterior mean of omega,
\item `omega_acceptance_rate': if omega was estimated, the rate of acceptance of proposed omega values in the Metropolis-Hastings sampling routine,  
\item `phi_estimated': logical value indicating whether the parameter phi was estimated,
\item `phi': the posterior mean of phi,
\item `phi_acceptance_rate': if phi was estimated, the rate of acceptance of proposed phi values in the Metropolis-Hastings sampling routine, 
\item `N`: number of cases in the analysis,
\item `k`: number of variants in the analysis,
\item `variant_counts': list of counts of each variant for cases and controls,
\item `temperatures': numeric vector of temperatures used as temperatures for tempered MCMC chains 
}
}
\seealso{
\code{\link{summary.BeviMed}}
}
