% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bIndpTest.R
\name{bIndpTest}
\alias{bIndpTest}
\title{bIndpTest function}
\usage{
bIndpTest(
  mat,
  i,
  j,
  z = c(),
  alpha = 0.05,
  IndpThs = 0.05,
  nboot = 100,
  pflag = FALSE
)
}
\arguments{
\item{mat}{is a matrix n by d where n is a number of transactions or samples and d is a number of dimensions.}

\item{i}{is an ith dimension in \code{mat}.}

\item{j}{is an jth dimension in \code{mat}.}

\item{z}{is a conditioning d-dimensional vector on \code{mat}.
Given k non-negative-bit positions of \code{z}, all k bit positions of samples in the subset of \code{mat} must have similar values with these bits.}

\item{alpha}{is a significance threshold for hypothesis tests (Mann Whitney)
that deploys for testing degrees of dependency, association direction, and causal direction. The default is 0.5.}

\item{IndpThs}{is a threshold for the degree of dependency. In the independence test, to claim that any variables are dependent, the dependency degree must greater than this value significantly. The default is 0.05.}

\item{nboot}{is a number of bootstrap replicates for bootstrapping deployed to infer confidence intervals and distributions for hypothesis tests. The default is 100.}

\item{pflag}{is a flag for printing progress message (TRUE). The default is FALSE (no printing).}
}
\value{
This function returns results of dependency inference between i and j.
\item{bmean}{A mean of dependency degrees between variables i and j.}
\item{confInv}{An \code{alpha}*100th percentile confidence interval of dependency degrees between variables i and j.}
\item{testRes}{A Mann-Whitney hypothesis test result for an independence test between variables i and j. The null hypothesis is that the distributions of dependency degrees of i,j differ by a location shift of \code{IndpThs} and the alternative is  that distributions of dependency degrees of i,j is shifted greater than \code{IndpThs}. }
}
\description{
This function infers dependency for a pair of variables i,j with bootstrapping.
}
\examples{
bIndpTest(mat=mat,i=1,j=2)


}
