% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{bdCreateEmptyDataset_hdf5}
\alias{bdCreateEmptyDataset_hdf5}
\title{Create groups}
\usage{
bdCreateEmptyDataset_hdf5(
  filename,
  group,
  dataset,
  nrows,
  ncols,
  overwrite = FALSE
)
}
\arguments{
\item{filename, }{character array indicating the name of the file to create}

\item{group, }{string with name of the group where the new dataset will be created}

\item{dataset, }{string with name for the new dataset}

\item{nrows, }{integer with the number of rows for the new dataset}

\item{ncols, }{integer with the number of columns for the new dataset}

\item{overwrite, }{optional boolean if true datasets exists, replaces old dataset with a new empty dataset}
}
\value{
none
}
\description{
Create groups in hdf5 data file
}
\examples{

matA <- matrix(c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15), nrow = 3, byrow = TRUE)

bdCreate_hdf5_matrix_file("BasicMatVect.hdf5", matA, "INPUT", "matA")

bdCreateEmptyDataset_hdf5("BasicMatVect.hdf5", "INPUT", "EmptyMat", 100, 10)


# Remove file (used as example)
  if (file.exists("BasicMatVect.hdf5")) {
    # Delete file if it exist
    file.remove("BasicMatVect.hdf5")
  }
  
}
