% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merge.R
\name{bdmerge}
\alias{bdmerge}
\title{Merge binary dosage files together}
\usage{
bdmerge(
  mergefiles,
  format = 4,
  subformat = 0L,
  bdfiles,
  famfiles = character(),
  mapfiles = character(),
  onegroup = TRUE,
  bdoptions = character(),
  snpjoin = "inner"
)
}
\arguments{
\item{mergefiles}{Vector of file names for the merged binary
files. The first is the
binary dosage data containing the dosages and genetic
probabilities. The second file name is the family information
file. The third file name is the SNP information file.
The family and SNP information files are not used if the
binary dosage file is in format 4. For this format the
family and SNP information are in the file with the dosages
and genetic probabilities.}

\item{format}{The format of the output binary dosage file.
Allowed values are 1, 2, 3, and 4. The default value is 4.
Using the default value is recommended.}

\item{subformat}{The subformat of the format of the output
binary dosage file. A value of 1 or 3 indicates that only the
dosage value is saved. A value of 2 or 4 indicates
the dosage and genetic probabilities will be output. Values
of 3 or 4 are only allowed with formats 3 and 4. If a value
of zero if provided, and genetic probabilities are in the vcf
file, subformat 2 will be used for formats 1 and 2, and
subformat 4 will be used for formats 3 and 4. If the vcf file
does not contain genetic probabilities, subformat 1 will be
used for formats 1 and 2, and subformat 3 will be used for
formats 3 and 4. The default value is 0.}

\item{bdfiles}{Vector of binary dosage file names to be merged.}

\item{famfiles}{Vector of family file names that correspond to
the names in bdfiles. If the binary dosage files are all in format
4, this may be an empty character array. Default value is character().}

\item{mapfiles}{Vector of map file names that correspond to the
names in bdfiles. If the binary dosage files are all in format
4, this may be an empty character array. Default value is character().}

\item{onegroup}{Indicator to combine all the samples in one group.
If this is FALSE, the groups in each binary dosage file are
maintained and any binary dosage file with one group is made into
its own group. Default value is TRUE.}

\item{bdoptions}{Options indicating what information to calculate
and store for each SNP. These can be aaf, maf, and rsq. This option
is only available if format is equal to 4 and onegroup is TRUE.
Default value is character().}

\item{snpjoin}{Character value that can be either "inner" or "outer".
This indicates whether to do an inner or outer join of the SNPs in
each binary dosage file. Default value is "inner".}
}
\value{
None
}
\description{
Routine to merge binary dosage files together. The files
don't have to be in the same format. They will be merged
into a file with the format specified. Information about
the SNPs, aaf, maf, avgcall, rsq, can be maintained for
each file, or recalculated for the merged set.
}
\examples{
bdvcf1afile <- system.file("extdata", "vcf1a.bdose", package = "BinaryDosage")
bdvcf1bfile <- system.file("extdata", "vcf1b.bdose", package = "BinaryDosage")
mergefiles <- tempfile()

BinaryDosage:::bdmerge(mergefiles = mergefiles,
                       bdfiles = c(bdvcf1afile, bdvcf1bfile),
                       bdoptions = "maf")
bdinfo <- getbdinfo(mergefiles)
}
