% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findClusters.R
\name{findClusters}
\alias{findClusters}
\title{Identification of clusters with similar temporal regulation}
\usage{
findClusters(peakdet, exprmat, maxclusters = 3, eps = 0.02,
  clusters = 3, method = "kmeans")
}
\arguments{
\item{peakdet}{A list returned by the peakDetection function.}

\item{exprmat}{A numeric matrix with expression series data with variables as rownames.}

\item{maxclusters}{Maximal number of clusters used for kmeans cluster estimation.}

\item{eps}{Epsilon value used by the dbscan algorithm.}

\item{clusters}{Number of clusters used for the cutree function of the hierarchical clustering.}

\item{method}{A character string defining the clustering algorithm with options: c('kmeans', 'dbscan', 'hclust').}
}
\value{
Returns a cluster assignment of each variable and the number of identified clusters.
}
\description{
The findClusters function estimates the number of genes with similar temporal regulation and supports three different
clustering algorithms: kmeans, dbscan and hierarchical clustering. Clustering is based on a PCA projection of the input
data.
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Define series
series <- c(37,40,41,42,43)
# Run the peak detection algorithm
peakdet <- peakDetection(heat, series, type ='rnaseq', actstrength = 1.5,
prominence = 1.3, minexpr = 5000)
# Cluster exploration using kmeans with a maximum of 4 clusters to be assigned
clusters <- findClusters(peakdet, heat, maxclusters = 4, method = 'kmeans')

}
\author{
David Lauenstein
}
