% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covsum_nested.R
\name{rm_covsum_nested}
\alias{rm_covsum_nested}
\title{Outputs a nested version of reportRmd::rm_covsum()}
\usage{
rm_covsum_nested(
  data,
  covs,
  maincov = NULL,
  id = NULL,
  caption = NULL,
  tableOnly = FALSE,
  covTitle = "",
  digits = 1,
  digits.cat = 0,
  nicenames = TRUE,
  IQR = FALSE,
  all.stats = FALSE,
  pvalue = TRUE,
  effSize = TRUE,
  p.adjust = "none",
  unformattedp = FALSE,
  show.tests = TRUE,
  just.nested.pvalue = FALSE,
  nCores = NULL,
  nested.test = NULL,
  nsim = NULL,
  testcont = c("rank-sum test", "ANOVA"),
  testcat = c("Chi-squared", "Fisher"),
  full = TRUE,
  include_missing = FALSE,
  percentage = c("column", "row"),
  dropLevels = TRUE,
  excludeLevels = NULL,
  numobs = NULL,
  markup = TRUE,
  sanitize = TRUE,
  chunk_label
)
}
\arguments{
\item{data}{dataframe containing data}

\item{covs}{character vector with the names of columns to include in table}

\item{maincov}{covariate to stratify table by}

\item{id}{covariates to nest summary by}

\item{caption}{character containing table caption (default is no caption)}

\item{tableOnly}{Logical, if TRUE then a dataframe is returned, otherwise a
formatted printed object is returned (default).}

\item{covTitle}{character with the names of the covariate (predictor) column.
The default is to leave this empty for output or, for table only output to
use the column name 'Covariate'.}

\item{digits}{number of digits for summarizing mean data}

\item{digits.cat}{number of digits for the proportions when summarizing
categorical data (default: 0)}

\item{nicenames}{boolean indicating if you want to replace . and _ in strings
with a space}

\item{IQR}{boolean indicating if you want to display the inter quantile range
(Q1,Q3) as opposed to (min,max) in the summary for continuous variables}

\item{all.stats}{boolean indicating if all summary statistics (Q1,Q3 +
min,max on a separate line) should be displayed. Overrides IQR.}

\item{pvalue}{boolean indicating if you want p-values included in the table}

\item{effSize}{boolean indicating if you want effect sizes included in the
table. Can only be obtained if pvalue is also requested.}

\item{p.adjust}{p-adjustments to be performed}

\item{unformattedp}{boolean indicating if you would like the p-value to be
returned unformatted (ie not rounded or prefixed with '<'). Best used with
tableOnly = T and outTable function.}

\item{show.tests}{boolean indicating if the type of statistical used should
be shown in a column beside the p-values. Ignored if pvalue=FALSE.}

\item{just.nested.pvalue}{boolean indicating if the just the nested p-value
should be shown in a column, and not unnested p-value, unnested statistical
tests and effect size. Overrides effSize and show.tests arguments.}

\item{nCores}{number of cores to use for parallel processing if calculating
the nested p-value (if provided).}

\item{nested.test}{specifies test used for calculating nested p-value from
afex::mixed function. Either \emph{parametric bootstrap} method
or \emph{likelihood ratio test} method (default: "LRT"). Parametric bootstrap
takes longer.}

\item{nsim}{specifies number of simulations to use for calculating nested p-value
with \emph{parametric bootstrap} method used for nested.test (default: 1000).}

\item{testcont}{test of choice for continuous variables,one of
\emph{rank-sum} (default) or \emph{ANOVA}}

\item{testcat}{test of choice for categorical variables,one of
\emph{Chi-squared} (default) or \emph{Fisher}}

\item{full}{boolean indicating if you want the full sample included in the
table, ignored if maincov is NULL}

\item{include_missing}{Option to include NA values of maincov. NAs will not
be included in statistical tests}

\item{percentage}{choice of how percentages are presented, one of
\emph{column} (default) or \emph{row}}

\item{dropLevels}{logical, indicating if empty factor levels be dropped from
the output, default is TRUE.}

\item{excludeLevels}{a named list of covariate levels to exclude from
statistical tests in the form list(varname =c('level1','level2')). These
levels will be excluded from association tests, but not the table. This can
be useful for levels where there is a logical skip (ie not missing, but not
presented). Ignored if pvalue=FALSE.}

\item{numobs}{named list overriding the number of people you expect to have
the covariate}

\item{markup}{boolean indicating if you want latex markup}

\item{sanitize}{boolean indicating if you want to sanitize all strings to not
break LaTeX}

\item{chunk_label}{only used if output is to Word to allow cross-referencing}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
Outputs a nested version of reportRmd::rm_covsum()
}
\examples{
\dontrun{
# Example 1
data(ae)
rm_covsum_nested(data = ae, id = c("ae_detail", "Subject"), covs = c("AE_SEV_GD", 
"AE_ONSET_DT_INT"), maincov = "CTC_AE_ATTR_SCALE")

# Example 2: set variable labels and other options, save output with markup
data("ae")
lbls <- data.frame(c1=c('AE_SEV_GD','AE_ONSET_DT_INT'),
    c2=c('Adverse event severity grade','Adverse event onset date'))
ae$AE_SEV_GD <- as.numeric(ae$AE_SEV_GD)
ae <- reportRmd::set_labels(ae, lbls)
output_tab <- rm_covsum_nested(data = ae, id = c("ae_detail", "Subject"), 
    covs = c("AE_SEV_GD", "AE_ONSET_DT_INT"), maincov = "CTC_AE_ATTR_SCALE", 
    testcat = "Fisher", percentage = c("col"), show.tests = FALSE, pvalue = TRUE, 
    effSize = FALSE, full = TRUE, IQR = FALSE, nicenames = TRUE, sanitize = TRUE, 
    markup = TRUE, include_missing = TRUE, just.nested.pvalue = TRUE, 
    tableOnly = TRUE)
cat(reportRmd::outTable(tab=output_tab))
cat(reportRmd::outTable(output_tab, format="html"), file = paste("./man/tables/", 
    "output_tab.html", sep=""))
cat(reportRmd::outTable(output_tab, format="latex"), file = paste("./man/tables/", 
    "output_tab.tex", sep=""))
}
}
\seealso{
\code{\link{fisher.test}},
\code{\link{chisq.test}}, \code{\link{wilcox.test}},
\code{\link{kruskal.test}}, and \code{\link{anova}}
}
\keyword{dataframe}
