% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simBin.R
\name{simBin}
\alias{simBin}
\title{Multivariate binary data}
\usage{
simBin(n, p, k, D, C = 1)
}
\arguments{
\item{n}{number of rows}

\item{p}{number of columns}

\item{k}{number of underlying dimensions in the model}

\item{D}{sparsity control}

\item{C}{variance control}
}
\value{
X: binary matrix,
P: predicted matrix,
Theta: matrix of natural parameters,
A: row markers,
B: column markers,
mu: offset term,
D: sparsity level,
n: number of rows,
p: number of columns
}
\description{
Simulate a binary data matrix based on a latent variables model
}
\examples{
x <- simBin(n = 100, p = 50, k = 3, D = 0.5)
}
\seealso{
\code{\link{cv_LogBip}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
