% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{SimulateData}
\alias{SimulateData}
\title{Simulate data for decomposition illustration}
\usage{
SimulateData(n.ind, n.genes, n.cells, cell.types, avg.props)
}
\arguments{
\item{n.ind}{Integer. Number of individuals to simulate}

\item{n.genes}{Integer. Number of genes to simulate}

\item{n.cells}{Integer. Number of cells per individual for single-cell data}

\item{cell.types}{Character vector. List of cell types to simulate}

\item{avg.props}{Numeric vector. List of average proportions for given 
cell types. Should be same length as cell.types and sum to 1}
}
\value{
A list with simulated single-cell in slot `sc.eset` and bulk in
  `bulk.eset`, as well as true proportions in `props` and marker genes
  in `markers`.
}
\description{
Simulates bulk and single-cell expression, as well as marker genes and
true proportions that can be used as an example of decomposition
}
\examples{
library(Biobase)
sim.data <- SimulateData(n.ind=10, n.genes=100, n.cells=100,
                         cell.types=c("Neurons", "Astrocytes", "Microglia"),
                         avg.props=c(.5, .3, .2))

}
