% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_GetFittedParameters.R
\name{BP_GetFittedParameters}
\alias{BP_GetFittedParameters}
\title{Return the fitted parameters}
\usage{
BP_GetFittedParameters(bone, analysis = 1, alloptim = FALSE)
}
\arguments{
\item{bone}{The bone image to be used}

\item{analysis}{Name or rank of analysis}

\item{alloptim}{If TRUE, return the complete object returned by optim}
}
\value{
The fitted parameters
}
\description{
Return the fitted parameters.
}
\details{
BP_GetFittedParameters returns the fitted parameters
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 BP_GetFittedParameters(bone, analysis="logistic")
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
