% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_FitMLRadialCompactness.R
\name{BP_FitMLRadialCompactness}
\alias{BP_FitMLRadialCompactness}
\title{Estimation of the likelihood of a bone section}
\usage{
BP_FitMLRadialCompactness(
  bone,
  fitted.parameters = NULL,
  priors = NULL,
  fixed.parameters = NULL,
  analysis = 1,
  silent = FALSE,
  twosteps = TRUE
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{fitted.parameters}{Parameters of the model to be fitted}

\item{priors}{If twosteps is TRUE, tell what prior should be used.}

\item{fixed.parameters}{Fixed parameters of the model}

\item{analysis}{Name or rank of analysis}

\item{silent}{Should the function displays some information?}

\item{twosteps}{Should a 2-steps analysis be performed?}
}
\value{
The -Ln L
}
\description{
Estimation of the compactness of a bone section using radial model.\cr
If the fitted.parameters and fixed.parameters are NULL and the analysis includes a 
BP_FitMLCompactness() result, the values of this result is used as a reference for 
fitted.parameters and fixed.parameters.\cr
If no BP_FitMLCompactness() result is available, it will use:\cr
fitted.parameters=c(P=0.5, S=0.05, Min=-2, Max=5); fixed.parameters=c(K1=1, K2=1).\cr
The reference for radial estimation of compactness is the trigonometric circle for rotation.angle=0 in 
BP_EstimateCompactness():\cr
- The top of the section is located at -pi/2.\cr
- The left of the section is located at -pi and +pi.\cr
- The bottom of the section is located at pi/2.\cr
- The right of the section is 0.\cr
If rotation.angle is different from 0, the value of rotation.angle is added to the angle modulo 2.pi.\cr
The two-steps analysis performs first a quasi-Newton method, then a Bayesian MCMC and finally again a quasi-Newton method. 
It generally ensures that global minimum is found. On the other hand, it doubles the time to complete for each angle.\cr
To control the parallel computing, use: \cr
options(mc.cores = [put here the number of cores you want use])\cr
options(forking = FALSE)\cr
The maximum number of cores is obtained by: parallel::detectCores()\cr
}
\details{
BP_FitMLRadialCompactness estimates likelihood of model of a bone section
}
\examples{
\dontrun{
# Not run
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 # or 
 bone <- BP_OpenImage(ijtiff=TRUE)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic", cut.angle=30)
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 plot(bone)
 plot(bone, type="observations")
 plot(bone, type="observations+model", analysis=1)
 fittedpar <- BP_GetFittedParameters(bone, analysis="logistic")
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=c(fittedpar, K1=1.01, K2=1.01), 
                fixed.parameters=NULL, analysis="flexit")
 bone <- BP_FitBayesianCompactness(bone, analysis="flexit")
 mcmc <- RM_get(bone, RMname = "flexit", value="mcmc")
 fittedpar <- as.parameters(mcmc)
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=fittedpar, 
                fixed.parameters=NULL, analysis="flexit")
 compare_AIC(Logistic=BP_GetFittedParameters(bone, analysis="logistic", alloptim=TRUE), 
             Flexit=BP_GetFittedParameters(bone, analysis="flexit", alloptim=TRUE))
 out4p <- plot(bone, type="observations+model", analysis="logistic")
 out6p <- plot(bone, type="observations+model", analysis="flexit")
 # The twosteps fit is more acurate but is around 100 times slower
 bone <- BP_FitMLRadialCompactness(bone, analysis="logistic", twosteps=TRUE)
 bone <- BP_FitMLRadialCompactness(bone, analysis="logistic", twosteps=FALSE)
 plot(bone, type="observations", angle=0)
 plot(bone, type="model", analysis="logistic", angle=0)
 plot(bone, type="observations+model", angle=0)
 plot(bone, type="observations+model", angle=pi)
 plot(bone, type="radial", radial.variable=c("P", "S"), analysis="logistic")
 plot(bone, type="radial", radial.variable=c("P", "S", "Min", "Max"), analysis="logistic")
 plot(bone, type="radial", radial.variable=c("TRC"), analysis="logistic")
 # Test using the change of orientation using default.angle from BP_EstimateCompactness():
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="logistic_rotation_pi")
 # With a pi rotation, the top moves to the bottom and the left moves to the right
 bone <- BP_EstimateCompactness(bone, rotation.angle=pi, analysis="logistic_rotation_pi")
 bone <- BP_FitMLRadialCompactness(bone, analysis="logistic_rotation_pi")
 plot(bone, type="radial", radial.variable=c("P", "S"), analysis="logistic")
 plot(bone, type="radial", radial.variable=c("P", "S"), analysis="logistic_rotation_pi")
 BP_Report(bone=bone, 
           analysis=1,
           docx=NULL, 
           pdf=NULL, 
           xlsx=file.path(getwd(), "report.xlsx"), 
           author="Marc Girondot", 
           title=attributes(bone)$name)
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
