% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate_partial_results.R
\name{consolidate_partial_results}
\alias{consolidate_partial_results}
\title{Consolidate results from partial files}
\usage{
consolidate_partial_results(Configuration, folder = "./nreps_files")
}
\arguments{
\item{Configuration}{a named list containing all parameters
required in a call to \code{\link[=run_experiment]{run_experiment()}} except
\code{instances} and \code{algorithms}. See the parameter list
and default values in \code{\link[=run_experiment]{run_experiment()}}. Notice that
this is always returned as part of the output structure
of \code{\link[=run_experiment]{run_experiment()}}, so it generally easier to just
retrieve it from previously saved results.}

\item{folder}{folder where the partial files are located.}
}
\value{
a list object containing the following fields:
\itemize{
\item \code{data.raw} - data frame containing all observations generated
\item \code{data.summary} - data frame summarizing the experiment.
\item \code{N} - number of instances sampled
\item \code{total.runs} - total number of algorithm runs performed
\item \code{instances.sampled} - names of the instances sampled
}
}
\description{
Consolidates results from a set of partial files (each generated by an
individual call to \code{\link[=calc_nreps]{calc_nreps()}}) into a single output structure, similar
(but not identical) to the output of \code{\link[=run_experiment]{run_experiment()}}. This is useful
e.g., to consolidate the results from interrupted experiments.
}
