% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate_cdm}
\alias{validate_cdm}
\alias{validateCdm}
\title{Validation report for a CDM}
\usage{
validate_cdm(cdm)

validateCdm(cdm)
}
\arguments{
\item{cdm}{A cdm reference object.}
}
\value{
Invisibly returns the cdm input
}
\description{
Print a short validation report for a cdm object. The validation includes
checking that column names are correct and that no tables are empty. A short
report is printed to the console. This function is meant for interactive use.
}
\examples{
\dontrun{
con <- DBI::dbConnect(duckdb::duckdb(), eunomia_dir())
cdm <- cdm_from_con(con, cdm_tables = c("person", "observation_period"))
validate_cdm(cdm)
DBI::dbDisconnect(con)
}
}
