% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binaryBenchmarkFunctions.R
\name{benchmarkGeneratorMaxCut}
\alias{benchmarkGeneratorMaxCut}
\title{MaxCut Benchmark Creation}
\usage{
benchmarkGeneratorMaxCut(N, A)
}
\arguments{
\item{N}{length of the bit strings}

\item{A}{The adjacency matrix of the graph. Will be created at random if not provided.}
}
\value{
the function of type cost=f(bitstring). Returned fitness values will be negative, for purpose of minimization.
}
\description{
Generates MaxCut problems, with binary decision variables.
The MaxCut Problems are transformed to minimization problems by negation.
}
\examples{
fun <- benchmarkGeneratorMaxCut(N=6)
fun(c(1,0,1,1,0,0))
fun(c(1,0,1,1,0,1))
fun(c(0,1,0,0,1,1))
fun <- benchmarkGeneratorMaxCut(A=matrix(c(0,1,0,1,1,0,1,0,0,1,0,1,1,0,1,0),4,4))
fun(c(1,0,1,0))
fun(c(1,0,1,1))
fun(c(0,1,0,1))

}
