% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CICA.R
\name{CICA}
\alias{CICA}
\title{CICA: Clusterwise Independent Component Analysis}
\usage{
CICA(
  DataList,
  nStarts,
  nComp,
  nClus,
  scale = TRUE,
  center = TRUE,
  rational = NULL,
  maxiter = 100,
  verbose = TRUE
)
}
\arguments{
\item{DataList}{a list of matrices}

\item{nStarts}{number of multiple starts}

\item{nComp}{number of ICA components per cluster}

\item{nClus}{number of clusters}

\item{scale}{scale each matrix to have an equal sum of squares}

\item{center}{mean center matrices}

\item{rational}{a rational starting seed, if NULL no rational starting seed is used}

\item{maxiter}{maximum number of iterations for each start}

\item{verbose}{print loss information to console}
}
\value{
\code{CICA} returns an object of \code{\link{class}} "CICA". It contains the estimated clustering, cluster specific component matrices and subject specific time course matrices
\item{P}{partitioning vector of size \code{length(DataList)}}
\item{Sr}{list of size \code{nClus}, containing cluster specific independent components}
\item{Ais}{list of size \code{length(DataList)}, containing subject specific time courses}
\item{Loss}{loss function value of the best start}
\item{LossStarts}{loss function values of all starts}
}
\description{
Main function to perform Clusterwise Independent Component Analysis
}
\examples{
data('ExampleData', package = 'CICA')
output <- CICA(DataList = ExampleData, nStarts = 3, nComp = 5, nClus = 3, verbose = FALSE)
summary(output)
}
\author{
Jeffrey Durieux
}
