% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CINNA.R
\name{misc_extract_components}
\alias{misc_extract_components}
\title{Component extraction of miscellaneous graph formats}
\usage{
misc_extract_components(
  x,
  directed = TRUE,
  mode = "directed",
  weighted = NULL,
  unibipartite = FALSE,
  diag = TRUE
)
}
\arguments{
\item{x}{The input could be an edgelist and an adjacency matrix}

\item{directed}{Whether to create a directed graph.(default=TRUE)}

\item{mode}{Character scalar, explain how should demonstrate the supplied matrix.
Possible values are: directed, undirected, upper, lower, max, min, plus.(default="directed")}

\item{weighted}{An argument for specifying whether the graph should be weighted or not.
If it is NULL then an unweighted graph is created.(default=NULL)}

\item{unibipartite}{A boolean parameter describing whether the input edge list is corresponding
to a bipartite graph. TRUE value specifies the biprtite graph and vice versa.(default=FALSE)}

\item{diag}{Logical scalar, whether to consider the diagonal of the matrix or not.
If it was FALSE then the diagonal spotted as zeros.(default=TRUE)}
}
\value{
a list including the components of the input graph as igraph objects
}
\description{
This function extracts all components of the input with various formats
and convert them as "igraph" objects.
}
\details{
This function assert components of the input object which can be an edgelist,
an adjacency matrix and a graphNEL object.
The result would be a list including components as seperated graphs.
}
\seealso{
\code{\link[igraph]{induced.subgraph}},\code{\link[igraph]{components}},
\code{\link[igraph]{graph_from_adjacency_matrix}}
}
\author{
Minoo Ashtiani, Mehdi Mirzaie, Mohieddin Jafari
}
