% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_spip.R
\name{run_spip}
\alias{run_spip}
\title{Run spip in a user-specified directory}
\usage{
run_spip(
  pars,
  dir = tempfile(),
  spip_seeds = ceiling(runif(2, 1, 1e+09)),
  num_pops = 1,
  allele_freqs = list(c(0.5, 0.5))
)
}
\arguments{
\item{pars}{A named list of parameter values.}

\item{dir}{The directory to run it in.  Defaults to a temp directory,
which will be unique every time it is run.}

\item{spip_seeds}{a vector of two positive integers. These get written to the
file spip_seeds, which is used by spip to seed its random number generator.  By
default, R supplies these two integers from its own random number generator.  This
way reproducible results from spip can be obtained by calling \code{set.seed()} from within
R before calling \code{run_spip()}.  For the most part, the user should never really have
to directly supply a value for spip_seeds.}

\item{num_pops}{the number of demes that are being simulated.  This is still being
implemented...}

\item{allele_freqs}{a list of allele frequencies provided if you want
to simulate unlinked genotypes for the sampled individuals. The default
is simply a single locus with two alleles at frequencies 0.5, 0.5, which
is provided because spip has to be given some allele frequencies if sampling
is to be carried out.  Note that a user-specified value to this option should
only be given if you want to actually simulate some genetic data from the
sampled individuals. The length of the list should be the number of loci
desired, and the length of each element should be the number of alleles.
For examples for three loci with 2, 3, and 4 equifrequent alleles, respectively,
you would provide \code{list(c(0.5, 0.5), c(0.3333, 0.3333, 0.3333), c(0.25, 0.25, 0.25, 0.25))}.
Note that allele frequencies will be normalized to sum to one within each locus.}
}
\value{
Returns the path to the temporary directory were \code{spip} was run and where the
processed output files can be found to be read in using \code{slurp_spip()}.
}
\description{
This runs it in a directory and the output from stdout
goes into a big file spip_out.txt in that directory. Currently
this is pretty bare bones.
}
\details{
This creates a temporary directory and runs spip in that directory, redirecting
stdout and stderr to files.  It then processes the output using awk to create a collection
of files.  If spip throws an error, the contents of stderr are written to the screen to notify
the user of how to correct their input.

For a full example of its use see the Vignette:
\code{vignette("species_1_simulation", package = "CKMRpop")}.
}
