% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_s3generics_clvdata.R
\name{as.data.table.clv.data}
\alias{as.data.table.clv.data}
\title{Coerce to a Data Table}
\usage{
\method{as.data.table}{clv.data}(
  x,
  keep.rownames = FALSE,
  Ids = NULL,
  sample = c("full", "estimation", "holdout"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{clv.data}.}

\item{keep.rownames}{Ignored}

\item{Ids}{Character vector of customer ids for which transactions should be extracted. \code{NULL} extracts all.}

\item{sample}{Name of sample for which transactions should be extracted,
either "estimation", "holdout", or "full" (default).}

\item{...}{Ignored}
}
\value{
A \code{data.table} with columns \code{Id}, \code{Date}, and \code{Price} (if present).
}
\description{
Extract a copy of the transaction data stored in the given clv.data object
into a data.table.
}
\examples{
library(data.table)
 \donttest{
data("cdnow")
clv.data.cdnow <- clvdata(data.transactions = cdnow,
                          date.format="ymd",
                          time.unit = "w",
                          estimation.split = 37)

# Extract all transaction data (all Ids, estimation and holdout period)
dt.trans <- as.data.table(clv.data.cdnow)

# Extract transaction data of estimation period
dt.trans <- as.data.table(clv.data.cdnow, sample="estimation")

# Extract transaction data of Ids "1", "2", and "999"
#  (estimation and holdout period)
dt.trans <- as.data.table(clv.data.cdnow, Ids = c("1", "2", "999"))

# Extract transaction data of Ids "1", "2", and "999" in estimation period
dt.trans <- as.data.table(clv.data.cdnow, Ids = c("1", "2", "999"),
                          sample="estimation")
}

}
