% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{calculateSi}
\alias{calculateSi}
\title{Calculates survival indices (S.Is) for a range of wells (casewells).
S.Is for a range of wells are calculated, that range is specified at the third place of wells argument list. This function call the rangemean function 
to calculate the mean of the  range of the specified range. S.I is calculated by (Case well- meanofemptyrange/mean    
of controlwell- meanofemptyrange). In the wells argument one should provide arguments in the triplet form that is first one is control 
data range, second one is the empty data range  while third one is the control range.}
\usage{
calculateSi(hashedplates, platekey, platetype, rowsperexperiment, wells)
}
\arguments{
\item{hashedplates}{A hash table of picked plates. It is the output of function "selectPlate".}

\item{platekey}{It is the key of the plate whose S.I is needed to be calculated.}

\item{platetype}{It is the type of plate (386 and 96).}

\item{rowsperexperiment}{It is the argument that specifies if the same experiment is reptead and how many times in a plate. If an experiment is 
repeated twice in adjacent rows then average of its values will be used in the SI calculation.}

\item{wells}{This argument can take a list of arguments in the triplet form. Where first argument of triplet is the range of control wells,
second argument is the range of empty wells while third one is the range of case wells. It is made so that in labs plates layouts can differ  
greatly. By using this  triplet scheme one can handel a number of palte layouts.}
}
\value{
A matrix with S.I showing values where they are actually exist on the plate.
}
\description{
Calculates survival indices (S.Is) for a range of wells (casewells).
S.Is for a range of wells are calculated, that range is specified at the third place of wells argument list. This function call the rangemean function 
to calculate the mean of the  range of the specified range. S.I is calculated by (Case well- meanofemptyrange/mean    
of controlwell- meanofemptyrange). In the wells argument one should provide arguments in the triplet form that is first one is control 
data range, second one is the empty data range  while third one is the control range.
}
\examples{
 
f <- system.file("extdata", "optima.log", package="COMBIA")
fileDF <- readFile(filename = f, separator = "\\t", noofrows_skip=0,
                    platetype="384") 
Generatedbarcode <- extractKey(keyposition = 2,
                            rawdata = fileDF, numberofrowsperplate = 17, 
                            doubleplateexperiment=TRUE) 
hashedplates <-  selectPlate(rawdata = fileDF,
                            processedbarcode = Generatedbarcode, 
                            numberofrowsperplate = 17,
                            selectionkey = "65000", 
                            doubleplateexperiment = TRUE  )
survivalindeces <- calculateSi(hashedplates = hashedplates, 
                                platekey = "7051", platetype = "384",rowsperexperiment=1,
                                wells = c( "c8:h8","c1:n1","c3:c7",    "c8:h8","c1:n1","c9:c11", 
                                "c8:h8","c1:n1","e3:e7",     "c8:h8","c1:n1","e9:e11",
                                "c8:h8","c1:n1","g3:g7",     "c8:h8","c1:n1","g9:g11") 
                              )    
}
\author{
Muhammad Kashif
}
