% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuncUserUncor.R
\name{cpbayes_uncor}
\alias{cpbayes_uncor}
\title{Run uncorrelated version of CPBayes.}
\usage{
cpbayes_uncor(BetaHat, SE, Phenotypes, Variant, UpdateDE = TRUE,
  MCMCiter = 20000, Burnin = 10000)
}
\arguments{
\item{BetaHat}{A numeric vector of dimension K where K is the number of phenotypes. It
contains the beta hat values across studies/traits. No default is specified.}

\item{SE}{A numeric vector with the same dimension as BetaHat providing the standard errors
corresponding to BetaHat. Every element of SE must be positive. No default is specified.}

\item{Phenotypes}{A character vector of the same dimension as BetaHat providing the name of
the phenotypes. Default is specified as trait1, trait2, . . . , traitK. Note that BetaHat,
 SE, and Phenotypes must be in the same order.}

\item{Variant}{A character vector of length 1 specifying the name of the genetic variant.
Default is `Variant'.}

\item{UpdateDE}{A logical vector of length 1. Default is TRUE. If FALSE, the variance of
the slab distribution is considered to be fixed at 1. If TRUE, it is updated at each MCMC
 iteration in a range (0.8-1.2).}

\item{MCMCiter}{A positive integer greater than or equal to 10,000. Default is 20,000.}

\item{Burnin}{A positive integer greater than or equal to 5,000. Default is 10,000. Note that
the MCMC sample size (MCMCiter - Burnin) must be at least 5,000.}
}
\value{
The output produced by the function is a list which consists of various components. 
   \item{variantName}{It is the name of the genetic variant provided by the user. If not
    specified by the user, default name is `variant'.} 
   \item{log10_BF}{It provides the log10(Bayes factor) produced by CPBayes that measures the
    evidence of the overall pleiotropic association.}
   \item{PPNA}{It provides the posterior probability of null association produced by CPBayes
    (a Bayesian analog of the p-value) which is another measure of the evidence of the 
    aggregate-level pleiotropic association.}
   \item{subset}{It provides the optimal subset of associated/non-null traits estimated
    by CPBayes. It is NULL if no phenotype is selected by CPBayes.}
   \item{important_traits}{It provides the traits which yield a trait-specific posterior probability of
    association (PPAj) > 25\%. Even if a phenotype is not selected in the optimal subset of non-null
     traits, it can produce a non-negligible value of trait-specific posterior probability of
      association (PPAj). We note that `important_traits' is expected to include the traits 
      already contained in `subset'. It provides both the name of the important traits and
       their corresponding values of PPAj. Always check out 'important_traits' even if 'subset' contains
        no trait or a single trait. It helps to better explain an observed pleiotropic signal.}
   \item{auxi_data}{It contains supplementary data generated by the MCMC which is used later 
    by the \code{\link{post_summaries}} function to provide additional insights into a pleiotropic signal.
     The supplementary data contained in auxi_data are as follows.
       \enumerate{
           \item traitNames: Name of all the phenotypes.
           \item K: Total number of phenotypes.
           \item mcmc.samplesize: MCMC sample size.
           \item PPAj: Trait-specific posterior probability of association for all the traits.
           \item Z.data: MCMC data on the latent association status of all the traits (Z).
           \item sim.beta: MCMC data on the unknown true genetic effect (beta) on all the traits.
       }
   }
   \item{runtime}{It provides the runtime (in seconds) taken by CPBayes. It will help the user
    to plan the whole analysis.}
}
\description{
Run uncorrelated version of CPBayes when the main genetic effect (beta/log(odds ratio)) estimates across
 studies/traits are uncorrelated.
}
\examples{
data(ExampleDataUncor)
BetaHat <- ExampleDataUncor$BetaHat
BetaHat
SE <- ExampleDataUncor$SE
SE
traitNames <- paste("Disease", 1:10, sep = "")
SNP1 <- "rs1234"
result <- cpbayes_uncor(BetaHat, SE, Phenotypes = traitNames, Variant = SNP1)
str(result)

}
\references{
Arunabha Majumdar, Tanushree Haldar, Sourabh Bhattacharya, John Witte.
 An efficient Bayesian meta-analysis 
 approach for studying cross-phenotype genetic associations (submitted). Available
 at: http://biorxiv.org/content/early/2017/01/18/101543.
}
\seealso{
\code{\link{post_summaries}}, \code{\link{cpbayes_cor}}, \code{\link{estimate_corln}}
}

