% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_rules.R
\name{generate_rules}
\alias{generate_rules}
\title{Generate rules}
\usage{
generate_rules(
  X,
  ite,
  intervention_vars,
  ntrees_rf,
  ntrees_gbm,
  node_size,
  max_nodes,
  max_depth,
  replace
)
}
\arguments{
\item{X}{A covariate matrix.}

\item{ite}{A vector of estimated ITE.}

\item{intervention_vars}{A vector of intervention-able variables used for
rules generation.}

\item{ntrees_rf}{A number of decision trees for the random forest algorithm.}

\item{ntrees_gbm}{A number of decision trees for the generalized boosted
regression modeling algorithm.}

\item{node_size}{Minimum size of the trees' terminal nodes.}

\item{max_nodes}{Maximum number of terminal nodes per tree.}

\item{max_depth}{Maximum rules length.}

\item{replace}{A boolean variable for replacement in bootstrapping.}
}
\value{
A list of rules (names).
}
\description{
Generates a list of rules characterizing the heterogeneity in the Conditional
Average Treatment Effect (CATE) by tree-based metods: random forest (RF) and
generalized boosted regression modeling (GBM).
}
\keyword{internal}
