% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_volcano_pourpoints.R
\name{ch_volcano_pourpoints}
\alias{ch_volcano_pourpoints}
\title{Creates a sample file of pour points}
\usage{
ch_volcano_pourpoints(pp_shp)
}
\arguments{
\item{pp_shp}{Name for shapefile to hold pour points}
}
\value{
Returns an \pkg{sf} object containing 2 pour points for the 
\code{volcano} DEM. The pour points are also written to the specified file.
}
\description{
Creates a file of pour points for the \code{volcano} DEM. The 
pour points define the outlets of sub-basins. These pour points are used
by examples within other functions.
}
\examples{
pourpoint_file <- tempfile("volcano_pourpoints", fileext = c(".shp"))
pourpoints <- ch_volcano_pourpoints(pourpoint_file)
plot(pourpoints)
}
\seealso{
\code{\link{ch_volcano_raster}} \code{\link{ch_wbt_pourpoints}}
}
\author{
Dan Moore and Kevin Shook
}
