% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WindCapacityFactor.R
\name{CST_WindCapacityFactor}
\alias{CST_WindCapacityFactor}
\title{Wind capacity factor on s2dv_cube objects}
\usage{
CST_WindCapacityFactor(
  wind,
  IEC_class = c("I", "I/II", "II", "II/III", "III"),
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  ncores = NULL
)
}
\arguments{
\item{wind}{An s2dv_cube object with instantaneous wind speeds expressed in m/s.}

\item{IEC_class}{A string indicating the IEC wind class (see IEC 61400-1) of 
the turbine to be selected. Classes \code{'I'}, \code{'II'} and \code{'III'}
are suitable for sites with an annual mean wind speed of 10, 8.5 and 7.5 m/s 
respectively. Classes \code{'I/II'} and \code{'II/III'} indicate 
intermediate turbines that fit both classes. More details of the five 
turbines and a plot of its power curves can be found in Lledó et al. (2019).}

\item{start}{An optional parameter to defined the initial date of the period
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to defined the final date of the period to
select from the data by providing a list of two elements: the final day of
the period and the final month of the period. By default it is set to NULL
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to
compute the indicator. By default, it is set to 'ftime'. More than one
dimension name matching the dimensions provided in the object
\code{data$data} can be specified.}

\item{ncores}{An integer indicating the number of cores to use in parallel
computation for temporal subsetting.}
}
\value{
An s2dv_cube object containing the Wind Capacity Factor (unitless).
}
\description{
Wind capacity factor computes the wind power generated by a 
specific wind turbine model under specific wind speed conditions, and 
expresses it as a fraction of the rated capacity (i.e. maximum power) of the 
turbine.

It is computed by means of a tabular power curve that relates 
wind speed to power output. The tabular values are interpolated with a linear 
piecewise approximating function to obtain a smooth power curve. Five 
different power curves that span different IEC classes can be selected (see 
below).
}
\examples{
wind <- array(rweibull(n = 100, shape = 2, scale = 6), c(member = 10, lat = 2, lon = 5))
wind <- CSTools::s2dv_cube(data = wind, lat = c(40, 41), lon = 1:5,
                          Variable = list(varName = 'sfcWind', level = 'Surface'), 
                          Datasets = 'synthetic', when = Sys.time(),
                          Dates = list(start = '1990-01-01 00:00:00', end = '1990-01-01 00:00:00'),
                          source_file = NA)
WCF <- CST_WindCapacityFactor(wind, IEC_class = "III")

}
\references{
Lledó, Ll., Torralba, V., Soret, A., Ramon, J., & Doblas-Reyes, F. J. (2019). 
Seasonal forecasts of wind power generation. Renewable Energy, 143, 91–100. https://doi.org/10.1016/j.renene.2019.04.135

International Standard IEC 61400-1 (third ed.) (2005)
}
\author{
Llorenç Lledó, \email{llledo@bsc.es}
}
