% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TotalSpellTimeExceedingThreshold.R
\name{TotalSpellTimeExceedingThreshold}
\alias{TotalSpellTimeExceedingThreshold}
\title{Total Spell Time Exceeding Threshold}
\usage{
TotalSpellTimeExceedingThreshold(
  data,
  threshold,
  spell,
  op = ">",
  dates = NULL,
  start = NULL,
  end = NULL,
  time_dim = "ftime",
  ncores = NULL
)
}
\arguments{
\item{data}{A multidimensional array with named dimensions.}

\item{threshold}{If only one threshold is used: it can be a multidimensional 
array with named dimensions. It must be in the same units and with the 
common dimensions of the same length as parameter 'data'. It can also be a
vector with the same length of 'time_dim' from 'data' or a scalar. If we 
want to use two thresholds: it can be a vector of two scalars, a list of 
two vectors with the same length of 'time_dim' from 'data' or a list of 
two multidimensional arrays with the common dimensions of the same length 
as parameter 'data'. If two thresholds are used, parameter 'op' must be 
also a vector of two elements.}

\item{spell}{A scalar indicating the minimum length of the spell.}

\item{op}{An operator '>' (by default), '<', '>=' or '<='. If  two thresholds
are used it has to be a vector of a pair of two logical operators: 
c('<', '>'), c('<', '>='), c('<=', '>'), c('<=', '>='), c('>', '<'), 
c('>', '<='), c('>=', '<'),c('>=', '<=')).}

\item{dates}{A vector of dates or a multidimensional array of dates with named
dimensions matching the dimensions on parameter 'data'. By default it is 
NULL, to select a period this parameter must be provided.}

\item{start}{An optional parameter to defined the initial date of the period 
to select from the data by providing a list of two elements: the initial 
date of the period and the initial month of the period. By default it is set
to NULL and the indicator is computed using all the data provided in 
\code{data}.}

\item{end}{An optional parameter to define the final date of the period to 
select from the data by providing a list of two elements: the final day of 
the period and the final month of the period. By default it is set to NULL 
and the indicator is computed using all the data provided in \code{data}.}

\item{time_dim}{A character string indicating the name of the dimension to 
compute the indicator. By default, it is set to 'ftime'. It can only
indicate one time dimension.}

\item{ncores}{An integer indicating the number of cores to use in parallel 
computation.}
}
\value{
A multidimensional array with named dimensions containing the number 
of days that are part of a spell within a threshold with dimensions of the 
input parameter 'data' except the dimension where the indicator has been 
computed.
}
\description{
The number of days (when daily data is provided) that are part of a spell 
(defined by its minimum length e.g. 6 consecutive days) that exceed (or not 
exceed) a threshold are calculated with \code{TotalSpellTimeExceedingThreshold}.
This function allows to compute indicators widely used in Climate Services, 
such as:
\itemize{
\code{WSDI}{Warm Spell Duration Index that count the total number of days 
            with at least 6 consecutive days when the daily temperature 
            maximum exceeds its 90th percentile.}
}
This function requires the data and the threshold to be in the same units. The 
90th percentile can be translate into absolute values given a reference 
dataset using function \code{Threshold} or the data can be transform into 
probabilites by using function \code{AbsToProbs}. See section @examples.
}
\details{
This function considers NA values as the end of the spell. For a 
different behaviour consider to modify the 'data' input by substituting NA 
values by values exceeding the threshold.
}
\examples{
data <- array(rnorm(120), c(member = 1, sdate = 2, ftime = 20, lat = 4))
threshold <- array(rnorm(4), c(lat = 4))
total <- TotalSpellTimeExceedingThreshold(data, threshold, spell = 6)

}
\seealso{
[Threshold()] and [AbsToProbs()].
}
