% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atoms.R
\docType{class}
\name{ProdEntries-class}
\alias{ProdEntries-class}
\alias{.ProdEntries}
\alias{ProdEntries}
\alias{to_numeric,ProdEntries-method}
\alias{sign_from_args,ProdEntries-method}
\alias{is_atom_convex,ProdEntries-method}
\alias{is_atom_concave,ProdEntries-method}
\alias{is_atom_log_log_convex,ProdEntries-method}
\alias{is_atom_log_log_concave,ProdEntries-method}
\alias{is_incr,ProdEntries-method}
\alias{is_decr,ProdEntries-method}
\alias{.column_grad,ProdEntries-method}
\alias{.grad,ProdEntries-method}
\title{The ProdEntries class.}
\usage{
ProdEntries(..., axis = NA_real_, keepdims = FALSE)

\S4method{to_numeric}{ProdEntries}(object, values)

\S4method{sign_from_args}{ProdEntries}(object)

\S4method{is_atom_convex}{ProdEntries}(object)

\S4method{is_atom_concave}{ProdEntries}(object)

\S4method{is_atom_log_log_convex}{ProdEntries}(object)

\S4method{is_atom_log_log_concave}{ProdEntries}(object)

\S4method{is_incr}{ProdEntries}(object, idx)

\S4method{is_decr}{ProdEntries}(object, idx)

\S4method{.column_grad}{ProdEntries}(object, value)

\S4method{.grad}{ProdEntries}(object, values)
}
\arguments{
\item{...}{\linkS4class{Expression} objects, vectors, or matrices.}

\item{axis}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}

\item{keepdims}{(Optional) Should dimensions be maintained when applying the atom along an axis? If \code{FALSE}, result will be collapsed into an \eqn{n x 1} column vector. The default is \code{FALSE}.}

\item{object}{A \linkS4class{ProdEntries} object.}

\item{values}{A list of numeric values for the arguments}

\item{idx}{An index into the atom.}

\item{value}{A numeric value.}
}
\description{
The product of the entries in an expression.
}
\section{Methods (by generic)}{
\itemize{
\item \code{to_numeric(ProdEntries)}: The product of all the entries.

\item \code{sign_from_args(ProdEntries)}: Returns the sign (is positive, is negative) of the atom.

\item \code{is_atom_convex(ProdEntries)}: Is the atom convex?

\item \code{is_atom_concave(ProdEntries)}: Is the atom concave?

\item \code{is_atom_log_log_convex(ProdEntries)}: Is the atom log-log convex?

\item \code{is_atom_log_log_concave(ProdEntries)}: is the atom log-log concave?

\item \code{is_incr(ProdEntries)}: Is the atom weakly increasing in the argument \code{idx}?

\item \code{is_decr(ProdEntries)}: Is the atom weakly decreasing in the argument \code{idx}?

\item \code{.column_grad(ProdEntries)}: Gives the (sub/super)gradient of the atom w.r.t. each column variable

\item \code{.grad(ProdEntries)}: Gives the (sub/super)gradient of the atom w.r.t. each variable

}}
\section{Slots}{

\describe{
\item{\code{expr}}{An \linkS4class{Expression} representing a vector or matrix.}

\item{\code{axis}}{(Optional) The dimension across which to apply the function: \code{1} indicates rows, \code{2} indicates columns, and \code{NA} indicates rows and columns. The default is \code{NA}.}
}}

