% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/no_calibration_CV.R
\name{uncalibrated_CV}
\alias{uncalibrated_CV}
\title{uncalibrated_CV}
\usage{
uncalibrated_CV(actual, predicted, n_folds = 10, seed, input)
}
\arguments{
\item{actual}{vector of observed class labels (0/1)}

\item{predicted}{vector of uncalibrated predictions}

\item{n_folds}{number of folds for the cross-validation, Default: 10}

\item{seed}{random seed to alternate the split of data set partitions}

\item{input}{specify if the input was scaled or transformed, scaled=1, transformed=2}
}
\value{
list object containing the following components:
\item{error}{list object that summarizes discrimination and calibration errors obtained during the CV}
\item{type}{"uncalibrated"}
\item{probs_CV}{vector of input-preprocessed predictions that was used during the CV}
\item{actual_CV}{respective vector of true values (0 or 1) that was used during the CV}
}
\description{
performs \code{n_folds}-CV but with only input-preprocessing the test set. No calibration model is trained and evaluated in this method.
The \code{predicted} values are partitioned into n subsets. The training set is constructed on (n-1) subsets; the remaining set is used
for testing. Since no calibration model is used in this method, the test set predictions are only input-preprocessed (either scaled or transformed, depending on \code{input}).
All test set predictions are merged and used to compute error metrics for the input-preprocessing methods.
}
