% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calSSB.R
\encoding{UTF8}
\name{CalibrateSSBpanel}
\alias{CalibrateSSBpanel}
\title{Calibration weighting and variance estimation for panel data}
\usage{
CalibrateSSBpanel(...)
}
\arguments{
\item{...}{Input to CalibrateSSB() and PanelEstimation()}
}
\value{
Output from PanelEstimation()
}
\description{
Calibration weighting and variance estimation for panel data
}
\examples{
z    = AkuData(3000)  # 3000 in each quarter
zPop = AkuData(10000)[,1:7]
lc = rbind(LagDiff(8,4),PeriodDiff(8,4))
rownames(lc) = c("diffQ1","diffQ2","diffQ3","diffQ4","diffYearMean")
CalibrateSSBpanel(grossSample=z,calmodel="~ sex*age", partition=c("year","q"),popData=zPop, 
       y=c("unemployed","workforce"),id="id",wave=c("year","q"),
       numerator="unemployed",linComb=lc)
}
\seealso{
\code{\link{CalibrateSSB}}, \code{\link{PanelEstimation}}.
}
