% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_models.R
\name{make_model}
\alias{make_model}
\title{Make a model}
\usage{
make_model(statement, add_causal_types = TRUE, nodal_types = NULL)
}
\arguments{
\item{statement}{A character. Statement describing causal
relations using \link{dagitty} syntax. Only directed relations are
permitted. For instance "X -> Y" or  "X1 -> Y <- X2; X1 -> X2".}

\item{add_causal_types}{Logical. Whether to create and attach causal
types to \code{model}. Defaults to `TRUE`.}

\item{nodal_types}{List of nodal types associated with model nodes}
}
\value{
An object of class \code{causal_model}.

An object of class \code{"causal_model"} is a list containing at least the
following components:
\item{statement}{A character vector of the statement that defines the model}
\item{dag}{A \code{data.frame} with columns `parent`and `children`
  indicating how nodes relate to each other.}
\item{nodes}{A named \code{list} with the nodes in the model}
\item{parents_df}{A \code{data.frame} listing nodes, whether they are
  root nodes or not, and the number of parents they have}
\item{nodal_types}{Optional: A named \code{list} with the nodal types in
  the model. List should be ordered according to the causal ordering of
  nodes. If NULL nodal types are generated. If FALSE, a parameters data
  frame is not generated.}
\item{parameters_df}{A \code{data.frame} with descriptive information
  of the parameters in the model}
\item{causal_types}{A \code{data.frame} listing causal types and the
  nodal types that produce them}
}
\description{
\code{make_model} uses \link{dagitty} syntax and functionality to
specify nodes and edges of a graph. Implied causal types are calculated
and default priors are provided under the assumption of no confounding.
Models can be updated with specification of a parameter matrix, \code{P}, by
providing restrictions on causal types, and/or by providing informative
priors on parameters. The default setting for a causal model have flat
(uniform) priors and parameters putting equal weight on each parameter
within each parameter set. These can be adjust with \code{set_priors}
and \code{set_parameters}
}
\examples{
make_model(statement = "X -> Y")
modelXKY <- make_model("X -> K -> Y; X -> Y")

# Example where cyclicaly dag attempted
\dontrun{
 modelXKX <- make_model("X -> K -> X")
}

# Examples with confounding
model <- make_model("X->Y; X <-> Y")
model$P
model <- make_model("Y2 <- X -> Y1; X <-> Y1; X <-> Y2")
dim(model$P)
model$P
model <- make_model("X1 -> Y <- X2; X1 <-> Y; X2 <-> Y")
dim(model$P)
model$parameters_df

# A single node graph is also possible
model <- make_model("X")

# Unconnected nodes not allowed
\dontrun{
 model <- make_model("X <-> Y")
}

nodal_types <-
  list(
    A = c("0","1"),
    B = c("0","1"),
    C = c("0","1"),
    D = c("0","1"),
    E = c("0","1"),
    Y = c(
      "00000000000000000000000000000000",
      "01010101010101010101010101010101",
      "00110011001100110011001100110011",
      "00001111000011110000111100001111",
      "00000000111111110000000011111111",
      "00000000000000001111111111111111",
      "11111111111111111111111111111111" ))

make_model("A -> Y; B ->Y; C->Y; D->Y; E->Y",
          nodal_types = nodal_types)$parameters_df

nodal_types = list(Y = c("01", "10"), Z = c("0", "1"))
make_model("Z -> Y", nodal_types = nodal_types)$parameters_df
make_model("Z -> Y", nodal_types = FALSE)$parents_df
}
