% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfS_Trapezoidal.R
\name{cfS_Trapezoidal}
\alias{cfS_Trapezoidal}
\title{Characteristic function of Trapezoidal distribution}
\usage{
cfS_Trapezoidal(t, a = 1, c = 1/3)
}
\arguments{
\item{t}{numerical values (number, vector...)}

\item{a}{number, a > 0, default value a = 1}

\item{c}{number, (\eqn{0 \le c \le a}), default value c = 1/3}
}
\value{
characteristic function cf(t) of the Triangular distribution on the interval (a, b) with mode c
}
\description{
cfS_Trapezoidal(t, a, c) (a > 0, c > 0, \eqn{c \le a}) evaluates the characteristic function cf(t) of
the Trapezoidal distribution on the interval (-a, a) with mode on the interval (-c, c)
(Trapezoidal distribution with mean = 0 and variance = ???
cfS_Trapezoidal(t, a, c) = (sin(w*at)/(w*at))*(sin((1-w)*at)/((1-w)*at))
}
\examples{
## EXAMPLE1 (CF of the Trapezoidal distribution with a = 1, c = 0.5)
t <- seq(-15, 15, length.out = 501)
plotGraf(function(t)
  cfS_Trapezoidal(t, c = 1 / 2), t,
  title = "CF of the Trapezoidal distribution with a = 1, c = 0.5")

## EXAMPLE2 (PDF/CDF of the compound Trapezoidal distribution with a = 1, c = 0.5)
cf <- function(t)
  cfS_Trapezoidal(t, c = 1 / 2)
x <- seq(-1, 1, length.out = 100)
prob <- c(0.9, 0.95, 0.99)
xRange <- 2
option <- list()
option$N <- 1000
option$dx <- 2 / pi / xRange
result <- cf2DistGP(cf, x, option = option)
}
\seealso{
For more details see WIKIPEDIA:
\url{https://en.wikipedia.org/wiki/Trapezoidal_distribution}

Other Continuous Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Beta}}, \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}}, \code{\link{cfS_Triangular}},
  \code{\link{cfX_Beta}}, \code{\link{cfX_ChiSquared}},
  \code{\link{cfX_Exponential}}, \code{\link{cfX_Gamma}},
  \code{\link{cfX_InverseGamma}},
  \code{\link{cfX_LogNormal}}, \code{\link{cfX_Normal}},
  \code{\link{cfX_PearsonV}},
  \code{\link{cfX_Rectangular}},
  \code{\link{cfX_Triangular}}

Other Symetric Probability distribution: \code{\link{cfS_Arcsine}},
  \code{\link{cfS_Gaussian}},
  \code{\link{cfS_Rectangular}},
  \code{\link{cfS_StudentT}}, \code{\link{cfS_Triangular}}
}

