% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHCA.R
\name{plotHCA}
\alias{plotHCA}
\title{Plot Dendrogram for Spectra Object}
\usage{
plotHCA(spectra, hclst, sub.title, use.sym, leg.loc, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{hclst}{A \code{\link{hclust}} object.}

\item{sub.title}{A character string for the subtitle.}

\item{use.sym}{Logical; if true, the color scheme will be black and
lower-case letters will be used to indicate group membership.}

\item{leg.loc}{Character; if \code{"none"} no legend will be drawn.
Otherwise, any string acceptable to \code{\link{legend}}.}

\item{\dots}{Additional parameters to be passed to the plotting routines.}
}
\value{
An object of class \code{\link{dendrogram}}. Side effect is a plot.
}
\description{
This function plots the results of an HCA analysis of a
\code{\link{Spectra}} object.  Not generally called by the user --
\code{\link{hcaSpectra}} and \code{\link{hcaScores}} use it (see those pages
for examples).
}
\author{
Bryan A. Hanson, DePauw University.
}
\references{
\url{https://github.com/bryanhanson/ChemoSpec}
}
\keyword{cluster}
\keyword{hplot}
\keyword{multivariate}

