% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicsOptions.R
\docType{data}
\name{GraphicsOptions}
\alias{GraphicsOptions}
\title{Graphic Output Options in ChemoSpec and ChemoSpec2D}
\description{
In \code{ChemoSpec} and \code{ChemoSpec2D}, the user may chose from the following graphics output options:
\itemize{
  \item \code{base} graphics (also the only style from the early days of \code{ChemoSpec} through version 5).
  \item \code{ggplot2} graphics, \emph{the default}.
  \item \code{plotly} graphics.
}
}
\details{
Here's how it works:
\itemize{
  \item Upon starting \code{ChemoSpec} or \code{ChemoSpec2D} the graphics output mode
        is set to \code{ggplot2}.
  \item To see the current value, do \code{\link[ChemoSpecUtils]{chkGraphicsOpt}}.  If by some chance the
        value is corrupted it will be set to \code{base}.
  \item To change the graphics output mode, do \code{options(ChemoSpecGraphics = 'option')},
        where 'option' is one of the options listed above.
  \item \code{ggplot2} graphics are not available for all plots.  If \code{ggplot2} graphics are not available,
        \code{base} graphics will be automatically used, regardless of the setting in
        \code{options(ChemoSpecGraphics)}.
}

What you can do with your plots:
\itemize{
  \item Base graphics are the original graphics option in \code{R}.  They cannot be modified.
  \item For \code{ggplot2} graphics, \code{ChemoSpec} and \code{ChemoSpec2D} employ \code{theme_bw}
        with only a
        very few modifications.  You can add things to your plot, or override the theme
        used here via the usual \code{ggplot2} methods.  A few simple examples are given below
        but this is not the place for a \code{ggplot2} tutorial.  See \url{https://ggplot2.tidyverse.org/}
        for all things \code{ggplot2}.
  \item \code{plotly} graphics is an interactive graphics option where the user can
        use the tools provided by \code{plotly} package and interact with the plot.
}
}
\examples{
if (checkForPackageWithVersion("ChemoSpec", 6.0)) {
  library("ChemoSpec")
  library("ggplot2")
  data(metMUD1)

# Using the default ggplot2 graphics
  p1 <- plotSpectra(metMUD1,
    which = c(10, 11), yrange = c(0, 1.5),
    offset = 0.06, amplify = 10, lab.pos = 0.5)
  p1

# Modifying ggplot2 graphics
# Add a title
  p2 <- p1 + ggtitle("metMUD1 NMR Data")
  p2

# Zoom the axes
  p3 <- p1 + coord_cartesian(xlim = c(1.5, 2.0))
  p3

# Change the ggplot2 theme
  p4 <- p1 + theme_gray() + theme(legend.position = "none")
  p4

# plotLoadings uses patchwork, whose plots are modified differently
  pca <- c_pcaSpectra(metMUD1)
  p5 <- plotLoadings(metMUD1, pca, loads = c(1, 2))
  p5
  p6 <- p5 + patchwork::plot_annotation(title = "metMUD1 NMR Data")
  p6
# but to change the theme on each subplot, use the & operator
  p7 <- p6 & theme_gray() # compare to p6 + theme_gray()
  p7
}

}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{utilities}
