% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addLegend.R
\name{.addLegend}
\alias{.addLegend}
\title{Add a Legend to a Plot}
\usage{
.addLegend(spectra, leg.loc, use.sym, ...)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec:Spectra]{ChemoSpec::Spectra()}} or \code{\link[ChemoSpec2D:Spectra2D]{ChemoSpec2D::Spectra2D()}}.}

\item{leg.loc}{Either a list with elements \code{x} and \code{y}, or a string like \code{'topright'}.  Values in a list should be on \verb{[0,1]}, i.e. the lower left of the plot area is \verb{0,0} and the upper right is \verb{1,1}.  Allowed string values are those described in \code{\link[graphics:legend]{graphics::legend()}} under 'Details'. A value of \code{'none'} is acceptable as well.}

\item{use.sym}{Logical; if true, the color scheme is set to black and the
points plotted with symbols.  Applies only to \code{ChemoSpec}.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
None.  Side effect is to modify an existing plot.
}
\description{
\emph{Internal function}.  Add a legend to a plot created by either \code{ChemoSpec} or \code{ChemoSpec2D}.
\code{ChemoSpec2D} does not use symbols.
}
\author{
Bryan A. Hanson (DePauw University).
}
\keyword{internal}
