% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenzcurve.R
\name{lorenzcurve}
\alias{lorenzcurve}
\title{The Lorenz curve}
\usage{
lorenzcurve(E, d, Rules, col = NULL, legend = TRUE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{Rules}{The rules: AA, APRO, CE, CEA, CEL, DT, MO, PIN, PRO, RA, Talmud.}

\item{col}{The colors. If col=NULL then the sequence of default colors is:
c("red", "blue", "green", "yellow", "pink", "coral4", "darkgray", "burlywood3", "black", "darkorange", "darkviolet").}

\item{legend}{A logical value. The color legend is shown if legend=TRUE.}
}
\value{
The graphical representation of the Lorenz curve of a rule (or several rules) for a claims problem.
}
\description{
This function returns the Lorenz curve of a rule for a claims problem.
}
\details{
Let \eqn{E> 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that the sum of claims \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di} exceeds the endowment.

Rearrange the claims from small to large, \eqn{0 \le d_1 \le...\le d_n}{%
0 \le d1 \le...\le dn}. The Lorenz curve represents the proportion of the awards given to each subset of claimants by a specific rule \eqn{R}  as a function of the
cumulative distribution of population.

The Lorenz curve of a rule \eqn{R} for the claims problem \eqn{(E,d)} is the polygonal path connecting the \eqn{n+1} points
\deqn{(0,0), (\frac{1}{n},\frac{R_1(E,d)}{E}),\dots,(\frac{n-1}{n},\frac{\sum_{i=1}^{n-1}R_i(E,d)}{E}),(1,1)}{%
(0,0) , (1/n,R1(E,d)/E) , (2/n , (R1(E,d)+R2(E,d))/E ,\dots , (1,1)}
Basically, it represents the cumulative percentage of the endowment assigned by the rule to each cumulative percentage of claimants.
}
\examples{
E=10
d=c(2,4,7,8)
Rules=c(AA,RA,Talmud,CEA,CEL)
col=c("red","blue","green","yellow","pink")
lorenzcurve(E,d,Rules,col)
}
\references{
Lorenz, M. O. (1905). Methods of measuring the concentration of wealth. Publications of the American statistical association, 9(70), 209-219.

Mirás Calvo, M.A., Núñez Lugilde, I., Quinteiro Sandomingo, C., and Sánchez-Rodríguez, E. (2021). Deviation from proportionality and Lorenz-dominance between
the average of awards and the standard rules for claims problems. Working paper 2021-01, ECOBAS.
}
\seealso{
\link{giniindex}, \link{cumulativecurve}, \link{proportionalityindex}, \link{indexpath}, \link{lorenzdominance}.
}
