% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIN.R
\name{PIN}
\alias{PIN}
\title{Piniles' rule}
\usage{
PIN(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the PIN rule. If name = TRUE, the name of the function (PIN) as a character string.
}
\description{
This function returns the awards vector assigned by the Piniles' rule (PIN) to a claims problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di \ge E}, the sum of claims \eqn{D} exceeds the endowment.

The Piniles' rule coincides with the constrained equal awards rule (CEA) applied to
the problem \eqn{(E, d/2)} if the endowment is less or equal than the half-sum of the claims, \eqn{D/2}.
Otherwise it assigns to each claimant \eqn{i} half of the claim, \eqn{d_i/2}{di/2} and,
then, it distributes the remainder with the CEA rule. Therefore:

If \eqn{E \le \frac{D}{2}}{E\le D/2} then,
\deqn{PIN(E,d)  = CEA(E,d/2).}{PIN(E,d)=CEA(E,d/2).}

If \eqn{E \ge \frac{D}{2}}{E\ge D/2} then,
\deqn{PIN(E,d)=d/2+CEA(E-D/2,d/2).}{PIN(E,d)=d/2+CEA(E-D/2,d/2).}
}
\examples{
E=10
d=c(2,4,7,8)
PIN(E,d)
}
\references{
Piniles, H.M. (1861). Darkah shel Torah. Forester, Vienna.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{CEA}, \link{Talmud}
}
