% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_3class.R
\name{plot.optThres3}
\alias{plot.optThres3}
\title{Plot of confidence regions for covariate-specific optimal pair of thresholds.}
\usage{
\method{plot}{optThres3}(
  x,
  ci.level = 0.95,
  colors = NULL,
  xlims,
  ylims,
  size.point = 0.5,
  size.path = 0.5,
  names.labels,
  file.name = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class "optThres3", i.e., a result of \code{\link{optThres3}}.}

\item{ci.level}{confidence level to be used for constructing the confidence regions; default is 0.95.}

\item{colors}{a string vector for the name(s) specifying color(s) to be used for drawing confidence regions. If specified, the dimension of the vector needs to be equal the number of considered points (each point corresponds to a set of values for the covariates).}

\item{xlims, ylims}{numeric vectors of dimension 2, giving the limits for x and y axes in the plot.}

\item{size.point, size.path}{numeric values, indicating sizes for point(s) and line(s) in the plot.}

\item{names.labels}{a optional character vector giving the label name for covariates.}

\item{file.name}{File name to create on disk.}

\item{...}{further arguments used with \code{\link{ggexport}} function, for example, \code{width}, \code{height}.}
}
\value{
\code{plot.optThres3} returns plots of confidence regions of covariate-specific optimal pair of thresholds.
}
\description{
This function plots confidence regions for covariate-specific optimal pair of thresholds.
}
\details{
\code{plot.optThres3} provides plots of confidence regions (and point estimates) of covariate-specific optimal pair of thresholds. The plots are based on \code{ggplot()}.
}
\seealso{
\code{\link{optThres3}}
}
