% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClustMMDD.R
\name{read.or.compute}
\alias{read.or.compute}
\title{Read a given model from a file or compute the estimates of paramaters if not found.}
\usage{
read.or.compute(xdata, xK, xS, xReferenceModel, xReferenceModelsIndex,
  xNberExploredModels, xFileNameExploredModels, cte = as.double(1),
  header = TRUE)
}
\arguments{
\item{xdata}{A list of dataset and several description paramaters such as frequencies.}

\item{xK}{The number of components (clusters or populations).}

\item{xS}{The subset of relevant variables.}

\item{xReferenceModel}{The indicator of if the model is a reference model in an exclusion step of the backward-stepwise explorer.}

\item{xReferenceModelsIndex}{The vector indicating the models that have once been a reference at an exclusion step.}

\item{xNberExploredModels}{The current number of explored models.}

\item{xFileNameExploredModels}{The explored models.}

\item{cte}{A constant real.}

\item{header}{Indication of the presence of header in the file.}
}
\description{
Read a given model from a file or compute the estimates of the parameters if not found. This function is not available for users.
}
\details{
  Not available for users.
}
\author{
Wilson Toussile
}
\references{
\itemize{
		\item  \href{http://projecteuclid.org/euclid.ejs/1379596773}{Dominique Bontemps and Wilson Toussile (2013)} : Clustering and 	variable selection for categorical multivariate data. Electronic Journal of Statistics, Volume 7, 2344-2371, ISSN.
		
		\item 	\href{http://link.springer.com/article/10.1007\%2Fs11634-009-0043-x}{Wilson Toussile and Elisabeth Gassiat (2009)} : Variable 	selection in model-based clustering using multilocus genotype data. Adv Data Anal Classif, Vol 3, number 2, 109-134.
	}
}
\seealso{
\code{\link{dimJump.R}} for data driven calibration of the penality function, and
	\code{\link{model.selection.R}} for model selection.
}

